/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-11 at 10:52:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerAutoHealingPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerAutoHealingPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The URL for the health check that signals autohealing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthCheck;

  /**
   * The number of seconds that the managed instance group waits before it applies autohealing
   * policies to new instances or recently recreated instances. This initial delay allows instances
   * to initialize and run their startup scripts before the instance group determines that they are
   * UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely.
   * This value must be from range [0, 3600].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer initialDelaySec;

  /**
   * Maximum number of instances that can be unavailable when autohealing. The instance is
   * considered available if all of the following conditions are satisfied: 1. Instance's status is
   * RUNNING. 2. Instance's liveness health check result was observed to be HEALTHY at least once.
   * By default, a percent value of 100% is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FixedOrPercent maxUnavailable;

  /**
   * The URL for the health check that signals autohealing.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthCheck() {
    return healthCheck;
  }

  /**
   * The URL for the health check that signals autohealing.
   * @param healthCheck healthCheck or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicy setHealthCheck(java.lang.String healthCheck) {
    this.healthCheck = healthCheck;
    return this;
  }

  /**
   * The number of seconds that the managed instance group waits before it applies autohealing
   * policies to new instances or recently recreated instances. This initial delay allows instances
   * to initialize and run their startup scripts before the instance group determines that they are
   * UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely.
   * This value must be from range [0, 3600].
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInitialDelaySec() {
    return initialDelaySec;
  }

  /**
   * The number of seconds that the managed instance group waits before it applies autohealing
   * policies to new instances or recently recreated instances. This initial delay allows instances
   * to initialize and run their startup scripts before the instance group determines that they are
   * UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely.
   * This value must be from range [0, 3600].
   * @param initialDelaySec initialDelaySec or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicy setInitialDelaySec(java.lang.Integer initialDelaySec) {
    this.initialDelaySec = initialDelaySec;
    return this;
  }

  /**
   * Maximum number of instances that can be unavailable when autohealing. The instance is
   * considered available if all of the following conditions are satisfied: 1. Instance's status is
   * RUNNING. 2. Instance's liveness health check result was observed to be HEALTHY at least once.
   * By default, a percent value of 100% is used.
   * @return value or {@code null} for none
   */
  public FixedOrPercent getMaxUnavailable() {
    return maxUnavailable;
  }

  /**
   * Maximum number of instances that can be unavailable when autohealing. The instance is
   * considered available if all of the following conditions are satisfied: 1. Instance's status is
   * RUNNING. 2. Instance's liveness health check result was observed to be HEALTHY at least once.
   * By default, a percent value of 100% is used.
   * @param maxUnavailable maxUnavailable or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicy setMaxUnavailable(FixedOrPercent maxUnavailable) {
    this.maxUnavailable = maxUnavailable;
    return this;
  }

  @Override
  public InstanceGroupManagerAutoHealingPolicy set(String fieldName, Object value) {
    return (InstanceGroupManagerAutoHealingPolicy) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerAutoHealingPolicy clone() {
    return (InstanceGroupManagerAutoHealingPolicy) super.clone();
  }

}
