/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-07-19 at 02:51:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for HTTPSHealthCheck.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HTTPSHealthCheck extends com.google.api.client.json.GenericJson {

  /**
   * The value of the host header in the HTTPS health check request. If left empty (default value),
   * the IP on behalf of which this health check is performed will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * The TCP port number for the health check request. The default value is 443. Valid values are 1
   * through 65535.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined,
   * port takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portName;

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String proxyHeader;

  /**
   * The request path of the HTTPS health check request. The default value is /.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestPath;

  /**
   * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the
   * default value), the status code determines health. The response data can only be ASCII.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String response;

  /**
   * The value of the host header in the HTTPS health check request. If left empty (default value),
   * the IP on behalf of which this health check is performed will be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * The value of the host header in the HTTPS health check request. If left empty (default value),
   * the IP on behalf of which this health check is performed will be used.
   * @param host host or {@code null} for none
   */
  public HTTPSHealthCheck setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * The TCP port number for the health check request. The default value is 443. Valid values are 1
   * through 65535.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The TCP port number for the health check request. The default value is 443. Valid values are 1
   * through 65535.
   * @param port port or {@code null} for none
   */
  public HTTPSHealthCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined,
   * port takes precedence.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortName() {
    return portName;
  }

  /**
   * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined,
   * port takes precedence.
   * @param portName portName or {@code null} for none
   */
  public HTTPSHealthCheck setPortName(java.lang.String portName) {
    this.portName = portName;
    return this;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getProxyHeader() {
    return proxyHeader;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @param proxyHeader proxyHeader or {@code null} for none
   */
  public HTTPSHealthCheck setProxyHeader(java.lang.String proxyHeader) {
    this.proxyHeader = proxyHeader;
    return this;
  }

  /**
   * The request path of the HTTPS health check request. The default value is /.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestPath() {
    return requestPath;
  }

  /**
   * The request path of the HTTPS health check request. The default value is /.
   * @param requestPath requestPath or {@code null} for none
   */
  public HTTPSHealthCheck setRequestPath(java.lang.String requestPath) {
    this.requestPath = requestPath;
    return this;
  }

  /**
   * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the
   * default value), the status code determines health. The response data can only be ASCII.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponse() {
    return response;
  }

  /**
   * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the
   * default value), the status code determines health. The response data can only be ASCII.
   * @param response response or {@code null} for none
   */
  public HTTPSHealthCheck setResponse(java.lang.String response) {
    this.response = response;
    return this;
  }

  @Override
  public HTTPSHealthCheck set(String fieldName, Object value) {
    return (HTTPSHealthCheck) super.set(fieldName, value);
  }

  @Override
  public HTTPSHealthCheck clone() {
    return (HTTPSHealthCheck) super.clone();
  }

}
