/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-07-24 at 20:26:41 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a match condition that incoming traffic is evaluated against. Exactly one field must
 * be specified.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRuleMatcher extends com.google.api.client.json.GenericJson {

  /**
   * CIDR IP address range. Only IPv4 is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> srcIpRanges;

  /**
   * Match by country or region code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> srcRegionCodes;

  /**
   * CIDR IP address range. Only IPv4 is supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSrcIpRanges() {
    return srcIpRanges;
  }

  /**
   * CIDR IP address range. Only IPv4 is supported.
   * @param srcIpRanges srcIpRanges or {@code null} for none
   */
  public SecurityPolicyRuleMatcher setSrcIpRanges(java.util.List<java.lang.String> srcIpRanges) {
    this.srcIpRanges = srcIpRanges;
    return this;
  }

  /**
   * Match by country or region code.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSrcRegionCodes() {
    return srcRegionCodes;
  }

  /**
   * Match by country or region code.
   * @param srcRegionCodes srcRegionCodes or {@code null} for none
   */
  public SecurityPolicyRuleMatcher setSrcRegionCodes(java.util.List<java.lang.String> srcRegionCodes) {
    this.srcRegionCodes = srcRegionCodes;
    return this;
  }

  @Override
  public SecurityPolicyRuleMatcher set(String fieldName, Object value) {
    return (SecurityPolicyRuleMatcher) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRuleMatcher clone() {
    return (SecurityPolicyRuleMatcher) super.clone();
  }

}
