/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-07-24 at 20:30:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An HttpsHealthCheck resource. This resource defines a template for how individual instances
 * should be checked for health, via HTTPS.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpsHealthCheck extends com.google.api.client.json.GenericJson {

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer checkIntervalSec;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The
   * default value is 2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer healthyThreshold;

  /**
   * The value of the host header in the HTTPS health check request. If left empty (default value),
   * the public IP on behalf of which this health check is performed will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The TCP port number for the HTTPS health check request. The default value is 443.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * The request path of the HTTPS health check request. The default value is "/".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestPath;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is
   * invalid for timeoutSec to have a greater value than checkIntervalSec.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer timeoutSec;

  /**
   * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The
   * default value is 2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer unhealthyThreshold;

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCheckIntervalSec() {
    return checkIntervalSec;
  }

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * @param checkIntervalSec checkIntervalSec or {@code null} for none
   */
  public HttpsHealthCheck setCheckIntervalSec(java.lang.Integer checkIntervalSec) {
    this.checkIntervalSec = checkIntervalSec;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public HttpsHealthCheck setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public HttpsHealthCheck setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The
   * default value is 2.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHealthyThreshold() {
    return healthyThreshold;
  }

  /**
   * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The
   * default value is 2.
   * @param healthyThreshold healthyThreshold or {@code null} for none
   */
  public HttpsHealthCheck setHealthyThreshold(java.lang.Integer healthyThreshold) {
    this.healthyThreshold = healthyThreshold;
    return this;
  }

  /**
   * The value of the host header in the HTTPS health check request. If left empty (default value),
   * the public IP on behalf of which this health check is performed will be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * The value of the host header in the HTTPS health check request. If left empty (default value),
   * the public IP on behalf of which this health check is performed will be used.
   * @param host host or {@code null} for none
   */
  public HttpsHealthCheck setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public HttpsHealthCheck setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public HttpsHealthCheck setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public HttpsHealthCheck setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The TCP port number for the HTTPS health check request. The default value is 443.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The TCP port number for the HTTPS health check request. The default value is 443.
   * @param port port or {@code null} for none
   */
  public HttpsHealthCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * The request path of the HTTPS health check request. The default value is "/".
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestPath() {
    return requestPath;
  }

  /**
   * The request path of the HTTPS health check request. The default value is "/".
   * @param requestPath requestPath or {@code null} for none
   */
  public HttpsHealthCheck setRequestPath(java.lang.String requestPath) {
    this.requestPath = requestPath;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public HttpsHealthCheck setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is
   * invalid for timeoutSec to have a greater value than checkIntervalSec.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTimeoutSec() {
    return timeoutSec;
  }

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is
   * invalid for timeoutSec to have a greater value than checkIntervalSec.
   * @param timeoutSec timeoutSec or {@code null} for none
   */
  public HttpsHealthCheck setTimeoutSec(java.lang.Integer timeoutSec) {
    this.timeoutSec = timeoutSec;
    return this;
  }

  /**
   * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The
   * default value is 2.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUnhealthyThreshold() {
    return unhealthyThreshold;
  }

  /**
   * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The
   * default value is 2.
   * @param unhealthyThreshold unhealthyThreshold or {@code null} for none
   */
  public HttpsHealthCheck setUnhealthyThreshold(java.lang.Integer unhealthyThreshold) {
    this.unhealthyThreshold = unhealthyThreshold;
    return this;
  }

  @Override
  public HttpsHealthCheck set(String fieldName, Object value) {
    return (HttpsHealthCheck) super.set(fieldName, value);
  }

  @Override
  public HttpsHealthCheck clone() {
    return (HttpsHealthCheck) super.clone();
  }

}
