/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-07-24 at 21:25:33 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Overrides of stateful properties for a given instance
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedInstanceOverride extends com.google.api.client.json.GenericJson {

  /**
   * Disk overrides defined for this instance
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ManagedInstanceOverrideDiskOverride> disks;

  /**
   * Metadata overrides defined for this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Metadata> metadata;

  static {
    // hack to force ProGuard to consider Metadata used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Metadata.class);
  }

  /**
   * [Output Only] Indicates where does the override come from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String origin;

  /**
   * Disk overrides defined for this instance
   * @return value or {@code null} for none
   */
  public java.util.List<ManagedInstanceOverrideDiskOverride> getDisks() {
    return disks;
  }

  /**
   * Disk overrides defined for this instance
   * @param disks disks or {@code null} for none
   */
  public ManagedInstanceOverride setDisks(java.util.List<ManagedInstanceOverrideDiskOverride> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * Metadata overrides defined for this instance.
   * @return value or {@code null} for none
   */
  public java.util.List<Metadata> getMetadata() {
    return metadata;
  }

  /**
   * Metadata overrides defined for this instance.
   * @param metadata metadata or {@code null} for none
   */
  public ManagedInstanceOverride setMetadata(java.util.List<Metadata> metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * [Output Only] Indicates where does the override come from.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrigin() {
    return origin;
  }

  /**
   * [Output Only] Indicates where does the override come from.
   * @param origin origin or {@code null} for none
   */
  public ManagedInstanceOverride setOrigin(java.lang.String origin) {
    this.origin = origin;
    return this;
  }

  @Override
  public ManagedInstanceOverride set(String fieldName, Object value) {
    return (ManagedInstanceOverride) super.set(fieldName, value);
  }

  @Override
  public ManagedInstanceOverride clone() {
    return (ManagedInstanceOverride) super.clone();
  }

  /**
   * Model definition for ManagedInstanceOverrideMetadata.
   */
  public static final class Metadata extends com.google.api.client.json.GenericJson {

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String key;

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 262144 bytes (256 KiB).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String value;

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * @return value or {@code null} for none
     */
    public java.lang.String getKey() {
      return key;
    }

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * @param key key or {@code null} for none
     */
    public Metadata setKey(java.lang.String key) {
      this.key = key;
      return this;
    }

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 262144 bytes (256 KiB).
     * @return value or {@code null} for none
     */
    public java.lang.String getValue() {
      return value;
    }

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 262144 bytes (256 KiB).
     * @param value value or {@code null} for none
     */
    public Metadata setValue(java.lang.String value) {
      this.value = value;
      return this;
    }

    @Override
    public Metadata set(String fieldName, Object value) {
      return (Metadata) super.set(fieldName, value);
    }

    @Override
    public Metadata clone() {
      return (Metadata) super.clone();
    }

  }

}
