/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-19 20:48:09 UTC)
 * on 2016-05-25 at 00:49:04 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerVersion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerVersion extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceTemplate;

  /**
   * If this field is set, IGM maintains a pool of standby instances created from instanceTemplate.
   * The number of standby instances is such that the total number of instances created from this
   * instanceTemplate is equal to InstanceGroupManager.targetSize regardless of what is the value of
   * targetSize.fixed or targetSize.percent. Standby instances are useful during the update, when
   * the user wants to be able to quickly rollout/rollback to the target version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean keepStandbyInstances;

  /**
   * Tag describing the version. Changing it may trigger an action configured in UpdatePolicy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tag;

  /**
   * Intended number of instances that are created from instanceTemplate. The final number of
   * instances created from instanceTemplate will be equal to: * if expressed as fixed number:
   * min(targetSize.fixed, instanceGroupManager.targetSize), * if expressed as percent:
   * ceiling(targetSize.percent * InstanceGroupManager.targetSize). If unset, this version will
   * handle all the remaining instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FixedOrPercent targetSize;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceTemplate() {
    return instanceTemplate;
  }

  /**
   * @param instanceTemplate instanceTemplate or {@code null} for none
   */
  public InstanceGroupManagerVersion setInstanceTemplate(java.lang.String instanceTemplate) {
    this.instanceTemplate = instanceTemplate;
    return this;
  }

  /**
   * If this field is set, IGM maintains a pool of standby instances created from instanceTemplate.
   * The number of standby instances is such that the total number of instances created from this
   * instanceTemplate is equal to InstanceGroupManager.targetSize regardless of what is the value of
   * targetSize.fixed or targetSize.percent. Standby instances are useful during the update, when
   * the user wants to be able to quickly rollout/rollback to the target version.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getKeepStandbyInstances() {
    return keepStandbyInstances;
  }

  /**
   * If this field is set, IGM maintains a pool of standby instances created from instanceTemplate.
   * The number of standby instances is such that the total number of instances created from this
   * instanceTemplate is equal to InstanceGroupManager.targetSize regardless of what is the value of
   * targetSize.fixed or targetSize.percent. Standby instances are useful during the update, when
   * the user wants to be able to quickly rollout/rollback to the target version.
   * @param keepStandbyInstances keepStandbyInstances or {@code null} for none
   */
  public InstanceGroupManagerVersion setKeepStandbyInstances(java.lang.Boolean keepStandbyInstances) {
    this.keepStandbyInstances = keepStandbyInstances;
    return this;
  }

  /**
   * Tag describing the version. Changing it may trigger an action configured in UpdatePolicy.
   * @return value or {@code null} for none
   */
  public java.lang.String getTag() {
    return tag;
  }

  /**
   * Tag describing the version. Changing it may trigger an action configured in UpdatePolicy.
   * @param tag tag or {@code null} for none
   */
  public InstanceGroupManagerVersion setTag(java.lang.String tag) {
    this.tag = tag;
    return this;
  }

  /**
   * Intended number of instances that are created from instanceTemplate. The final number of
   * instances created from instanceTemplate will be equal to: * if expressed as fixed number:
   * min(targetSize.fixed, instanceGroupManager.targetSize), * if expressed as percent:
   * ceiling(targetSize.percent * InstanceGroupManager.targetSize). If unset, this version will
   * handle all the remaining instances.
   * @return value or {@code null} for none
   */
  public FixedOrPercent getTargetSize() {
    return targetSize;
  }

  /**
   * Intended number of instances that are created from instanceTemplate. The final number of
   * instances created from instanceTemplate will be equal to: * if expressed as fixed number:
   * min(targetSize.fixed, instanceGroupManager.targetSize), * if expressed as percent:
   * ceiling(targetSize.percent * InstanceGroupManager.targetSize). If unset, this version will
   * handle all the remaining instances.
   * @param targetSize targetSize or {@code null} for none
   */
  public InstanceGroupManagerVersion setTargetSize(FixedOrPercent targetSize) {
    this.targetSize = targetSize;
    return this;
  }

  @Override
  public InstanceGroupManagerVersion set(String fieldName, Object value) {
    return (InstanceGroupManagerVersion) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerVersion clone() {
    return (InstanceGroupManagerVersion) super.clone();
  }

}
