/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-27 at 07:10:45 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration parameters of autoscaling based on queuing system.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicyQueueBasedScaling extends com.google.api.client.json.GenericJson {

  /**
   * Scaling based on the average number of tasks in the queue per each active instance. The
   * autoscaler keeps the average number of tasks per instance below this number, based on data
   * collected in the last couple of minutes. The autoscaler will also take into account incoming
   * tasks when calculating when to scale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double acceptableBacklogPerInstance;

  /**
   * Configuration for Cloud Pub/Sub subscription queue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoscalingPolicyQueueBasedScalingCloudPubSub cloudPubSub;

  /**
   * The scaling algorithm will also calculate throughput estimates on its own; if you explicitly
   * provide this value, the autoscaler will take into account your value as well as automatic
   * estimates when deciding how to scale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double singleWorkerThroughputPerSec;

  /**
   * Scaling based on the average number of tasks in the queue per each active instance. The
   * autoscaler keeps the average number of tasks per instance below this number, based on data
   * collected in the last couple of minutes. The autoscaler will also take into account incoming
   * tasks when calculating when to scale.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAcceptableBacklogPerInstance() {
    return acceptableBacklogPerInstance;
  }

  /**
   * Scaling based on the average number of tasks in the queue per each active instance. The
   * autoscaler keeps the average number of tasks per instance below this number, based on data
   * collected in the last couple of minutes. The autoscaler will also take into account incoming
   * tasks when calculating when to scale.
   * @param acceptableBacklogPerInstance acceptableBacklogPerInstance or {@code null} for none
   */
  public AutoscalingPolicyQueueBasedScaling setAcceptableBacklogPerInstance(java.lang.Double acceptableBacklogPerInstance) {
    this.acceptableBacklogPerInstance = acceptableBacklogPerInstance;
    return this;
  }

  /**
   * Configuration for Cloud Pub/Sub subscription queue.
   * @return value or {@code null} for none
   */
  public AutoscalingPolicyQueueBasedScalingCloudPubSub getCloudPubSub() {
    return cloudPubSub;
  }

  /**
   * Configuration for Cloud Pub/Sub subscription queue.
   * @param cloudPubSub cloudPubSub or {@code null} for none
   */
  public AutoscalingPolicyQueueBasedScaling setCloudPubSub(AutoscalingPolicyQueueBasedScalingCloudPubSub cloudPubSub) {
    this.cloudPubSub = cloudPubSub;
    return this;
  }

  /**
   * The scaling algorithm will also calculate throughput estimates on its own; if you explicitly
   * provide this value, the autoscaler will take into account your value as well as automatic
   * estimates when deciding how to scale.
   * @return value or {@code null} for none
   */
  public java.lang.Double getSingleWorkerThroughputPerSec() {
    return singleWorkerThroughputPerSec;
  }

  /**
   * The scaling algorithm will also calculate throughput estimates on its own; if you explicitly
   * provide this value, the autoscaler will take into account your value as well as automatic
   * estimates when deciding how to scale.
   * @param singleWorkerThroughputPerSec singleWorkerThroughputPerSec or {@code null} for none
   */
  public AutoscalingPolicyQueueBasedScaling setSingleWorkerThroughputPerSec(java.lang.Double singleWorkerThroughputPerSec) {
    this.singleWorkerThroughputPerSec = singleWorkerThroughputPerSec;
    return this;
  }

  @Override
  public AutoscalingPolicyQueueBasedScaling set(String fieldName, Object value) {
    return (AutoscalingPolicyQueueBasedScaling) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicyQueueBasedScaling clone() {
    return (AutoscalingPolicyQueueBasedScaling) super.clone();
  }

}
