/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-27 at 07:10:45 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Message containing Cloud CDN configuration for a backend service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceCdnPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The CacheKeyPolicy for this CdnPolicy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CacheKeyPolicy cacheKeyPolicy;

  /**
   * Number of seconds up to which the response to a signed URL request will be cached in the CDN.
   * After this time period, the Signed URL will be revalidated before being served. Defaults to 1hr
   * (3600s). If this field is set, Cloud CDN will internally act as though all responses from this
   * backend had a ?Cache-Control: public, max-age=[TTL]? header, regardless of any existing Cache-
   * Control header. The actual headers served in responses will not be altered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long signedUrlCacheMaxAgeSec;

  /**
   * [Output Only] Names of the keys currently configured for Cloud CDN Signed URL on this backend
   * service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> signedUrlKeyNames;

  /**
   * The CacheKeyPolicy for this CdnPolicy.
   * @return value or {@code null} for none
   */
  public CacheKeyPolicy getCacheKeyPolicy() {
    return cacheKeyPolicy;
  }

  /**
   * The CacheKeyPolicy for this CdnPolicy.
   * @param cacheKeyPolicy cacheKeyPolicy or {@code null} for none
   */
  public BackendServiceCdnPolicy setCacheKeyPolicy(CacheKeyPolicy cacheKeyPolicy) {
    this.cacheKeyPolicy = cacheKeyPolicy;
    return this;
  }

  /**
   * Number of seconds up to which the response to a signed URL request will be cached in the CDN.
   * After this time period, the Signed URL will be revalidated before being served. Defaults to 1hr
   * (3600s). If this field is set, Cloud CDN will internally act as though all responses from this
   * backend had a ?Cache-Control: public, max-age=[TTL]? header, regardless of any existing Cache-
   * Control header. The actual headers served in responses will not be altered.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSignedUrlCacheMaxAgeSec() {
    return signedUrlCacheMaxAgeSec;
  }

  /**
   * Number of seconds up to which the response to a signed URL request will be cached in the CDN.
   * After this time period, the Signed URL will be revalidated before being served. Defaults to 1hr
   * (3600s). If this field is set, Cloud CDN will internally act as though all responses from this
   * backend had a ?Cache-Control: public, max-age=[TTL]? header, regardless of any existing Cache-
   * Control header. The actual headers served in responses will not be altered.
   * @param signedUrlCacheMaxAgeSec signedUrlCacheMaxAgeSec or {@code null} for none
   */
  public BackendServiceCdnPolicy setSignedUrlCacheMaxAgeSec(java.lang.Long signedUrlCacheMaxAgeSec) {
    this.signedUrlCacheMaxAgeSec = signedUrlCacheMaxAgeSec;
    return this;
  }

  /**
   * [Output Only] Names of the keys currently configured for Cloud CDN Signed URL on this backend
   * service.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSignedUrlKeyNames() {
    return signedUrlKeyNames;
  }

  /**
   * [Output Only] Names of the keys currently configured for Cloud CDN Signed URL on this backend
   * service.
   * @param signedUrlKeyNames signedUrlKeyNames or {@code null} for none
   */
  public BackendServiceCdnPolicy setSignedUrlKeyNames(java.util.List<java.lang.String> signedUrlKeyNames) {
    this.signedUrlKeyNames = signedUrlKeyNames;
    return this;
  }

  @Override
  public BackendServiceCdnPolicy set(String fieldName, Object value) {
    return (BackendServiceCdnPolicy) super.set(fieldName, value);
  }

  @Override
  public BackendServiceCdnPolicy clone() {
    return (BackendServiceCdnPolicy) super.clone();
  }

}
