/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-27 at 07:10:45 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * InstanceGroupManagers.applyUpdatesToInstances
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagersApplyUpdatesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The list of URLs of one or more instances for which we want to apply updates on this managed
   * instance group. This can be a full URL or a partial URL, such as
   * zones/[ZONE]/instances/[INSTANCE_NAME].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> instances;

  /**
   * The maximal action that should be perfomed on the instances. By default REPLACE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maximalAction;

  /**
   * The minimal action that should be perfomed on the instances. By default NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minimalAction;

  /**
   * The list of URLs of one or more instances for which we want to apply updates on this managed
   * instance group. This can be a full URL or a partial URL, such as
   * zones/[ZONE]/instances/[INSTANCE_NAME].
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInstances() {
    return instances;
  }

  /**
   * The list of URLs of one or more instances for which we want to apply updates on this managed
   * instance group. This can be a full URL or a partial URL, such as
   * zones/[ZONE]/instances/[INSTANCE_NAME].
   * @param instances instances or {@code null} for none
   */
  public InstanceGroupManagersApplyUpdatesRequest setInstances(java.util.List<java.lang.String> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * The maximal action that should be perfomed on the instances. By default REPLACE.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaximalAction() {
    return maximalAction;
  }

  /**
   * The maximal action that should be perfomed on the instances. By default REPLACE.
   * @param maximalAction maximalAction or {@code null} for none
   */
  public InstanceGroupManagersApplyUpdatesRequest setMaximalAction(java.lang.String maximalAction) {
    this.maximalAction = maximalAction;
    return this;
  }

  /**
   * The minimal action that should be perfomed on the instances. By default NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinimalAction() {
    return minimalAction;
  }

  /**
   * The minimal action that should be perfomed on the instances. By default NONE.
   * @param minimalAction minimalAction or {@code null} for none
   */
  public InstanceGroupManagersApplyUpdatesRequest setMinimalAction(java.lang.String minimalAction) {
    this.minimalAction = minimalAction;
    return this;
  }

  @Override
  public InstanceGroupManagersApplyUpdatesRequest set(String fieldName, Object value) {
    return (InstanceGroupManagersApplyUpdatesRequest) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagersApplyUpdatesRequest clone() {
    return (InstanceGroupManagersApplyUpdatesRequest) super.clone();
  }

}
