/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-27 at 01:25:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerVersion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerVersion extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceTemplate;

  /**
   * Name of the version. Unique among all versions in the scope of this managed instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Tag describing the version. Used to trigger rollout of a target version even if
   * instance_template remains unchanged. Deprecated in favor of 'name'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tag;

  /**
   * Intended number of instances that are created from instanceTemplate. The final number of
   * instances created from instanceTemplate will be equal to: * if expressed as fixed number:
   * min(targetSize.fixed, instanceGroupManager.targetSize), * if expressed as percent:
   * ceiling(targetSize.percent * InstanceGroupManager.targetSize). If unset, this version will
   * handle all the remaining instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FixedOrPercent targetSize;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceTemplate() {
    return instanceTemplate;
  }

  /**
   * @param instanceTemplate instanceTemplate or {@code null} for none
   */
  public InstanceGroupManagerVersion setInstanceTemplate(java.lang.String instanceTemplate) {
    this.instanceTemplate = instanceTemplate;
    return this;
  }

  /**
   * Name of the version. Unique among all versions in the scope of this managed instance group.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the version. Unique among all versions in the scope of this managed instance group.
   * @param name name or {@code null} for none
   */
  public InstanceGroupManagerVersion setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Tag describing the version. Used to trigger rollout of a target version even if
   * instance_template remains unchanged. Deprecated in favor of 'name'.
   * @return value or {@code null} for none
   */
  public java.lang.String getTag() {
    return tag;
  }

  /**
   * Tag describing the version. Used to trigger rollout of a target version even if
   * instance_template remains unchanged. Deprecated in favor of 'name'.
   * @param tag tag or {@code null} for none
   */
  public InstanceGroupManagerVersion setTag(java.lang.String tag) {
    this.tag = tag;
    return this;
  }

  /**
   * Intended number of instances that are created from instanceTemplate. The final number of
   * instances created from instanceTemplate will be equal to: * if expressed as fixed number:
   * min(targetSize.fixed, instanceGroupManager.targetSize), * if expressed as percent:
   * ceiling(targetSize.percent * InstanceGroupManager.targetSize). If unset, this version will
   * handle all the remaining instances.
   * @return value or {@code null} for none
   */
  public FixedOrPercent getTargetSize() {
    return targetSize;
  }

  /**
   * Intended number of instances that are created from instanceTemplate. The final number of
   * instances created from instanceTemplate will be equal to: * if expressed as fixed number:
   * min(targetSize.fixed, instanceGroupManager.targetSize), * if expressed as percent:
   * ceiling(targetSize.percent * InstanceGroupManager.targetSize). If unset, this version will
   * handle all the remaining instances.
   * @param targetSize targetSize or {@code null} for none
   */
  public InstanceGroupManagerVersion setTargetSize(FixedOrPercent targetSize) {
    this.targetSize = targetSize;
    return this;
  }

  @Override
  public InstanceGroupManagerVersion set(String fieldName, Object value) {
    return (InstanceGroupManagerVersion) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerVersion clone() {
    return (InstanceGroupManagerVersion) super.clone();
  }

}
