/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.services.compute.model.CustomerEncryptionKey;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.GuestOsFeature;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Image
extends GenericJson {
    @Key
    @JsonString
    private Long archiveSizeBytes;
    @Key
    private String creationTimestamp;
    @Key
    private DeprecationStatus deprecated;
    @Key
    private String description;
    @Key
    @JsonString
    private Long diskSizeGb;
    @Key
    private String family;
    @Key
    private List<GuestOsFeature> guestOsFeatures;
    @Key
    @JsonString
    private BigInteger id;
    @Key
    private CustomerEncryptionKey imageEncryptionKey;
    @Key
    private String kind;
    @Key
    private String labelFingerprint;
    @Key
    private Map<String, String> labels;
    @Key
    @JsonString
    private List<Long> licenseCodes;
    @Key
    private List<String> licenses;
    @Key
    private String name;
    @Key
    private RawDisk rawDisk;
    @Key
    private String selfLink;
    @Key
    private String sourceDisk;
    @Key
    private CustomerEncryptionKey sourceDiskEncryptionKey;
    @Key
    private String sourceDiskId;
    @Key
    private String sourceImage;
    @Key
    private CustomerEncryptionKey sourceImageEncryptionKey;
    @Key
    private String sourceImageId;
    @Key
    private String sourceType;
    @Key
    private String status;

    public Long getArchiveSizeBytes() {
        return this.archiveSizeBytes;
    }

    public Image setArchiveSizeBytes(Long l) {
        this.archiveSizeBytes = l;
        return this;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Image setCreationTimestamp(String string) {
        this.creationTimestamp = string;
        return this;
    }

    public DeprecationStatus getDeprecated() {
        return this.deprecated;
    }

    public Image setDeprecated(DeprecationStatus deprecationStatus) {
        this.deprecated = deprecationStatus;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Image setDescription(String string) {
        this.description = string;
        return this;
    }

    public Long getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public Image setDiskSizeGb(Long l) {
        this.diskSizeGb = l;
        return this;
    }

    public String getFamily() {
        return this.family;
    }

    public Image setFamily(String string) {
        this.family = string;
        return this;
    }

    public List<GuestOsFeature> getGuestOsFeatures() {
        return this.guestOsFeatures;
    }

    public Image setGuestOsFeatures(List<GuestOsFeature> list) {
        this.guestOsFeatures = list;
        return this;
    }

    public BigInteger getId() {
        return this.id;
    }

    public Image setId(BigInteger bigInteger) {
        this.id = bigInteger;
        return this;
    }

    public CustomerEncryptionKey getImageEncryptionKey() {
        return this.imageEncryptionKey;
    }

    public Image setImageEncryptionKey(CustomerEncryptionKey customerEncryptionKey) {
        this.imageEncryptionKey = customerEncryptionKey;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public Image setKind(String string) {
        this.kind = string;
        return this;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public byte[] decodeLabelFingerprint() {
        return Base64.decodeBase64((String)this.labelFingerprint);
    }

    public Image setLabelFingerprint(String string) {
        this.labelFingerprint = string;
        return this;
    }

    public Image encodeLabelFingerprint(byte[] byArray) {
        this.labelFingerprint = Base64.encodeBase64URLSafeString((byte[])byArray);
        return this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Image setLabels(Map<String, String> map) {
        this.labels = map;
        return this;
    }

    public List<Long> getLicenseCodes() {
        return this.licenseCodes;
    }

    public Image setLicenseCodes(List<Long> list) {
        this.licenseCodes = list;
        return this;
    }

    public List<String> getLicenses() {
        return this.licenses;
    }

    public Image setLicenses(List<String> list) {
        this.licenses = list;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Image setName(String string) {
        this.name = string;
        return this;
    }

    public RawDisk getRawDisk() {
        return this.rawDisk;
    }

    public Image setRawDisk(RawDisk rawDisk) {
        this.rawDisk = rawDisk;
        return this;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Image setSelfLink(String string) {
        this.selfLink = string;
        return this;
    }

    public String getSourceDisk() {
        return this.sourceDisk;
    }

    public Image setSourceDisk(String string) {
        this.sourceDisk = string;
        return this;
    }

    public CustomerEncryptionKey getSourceDiskEncryptionKey() {
        return this.sourceDiskEncryptionKey;
    }

    public Image setSourceDiskEncryptionKey(CustomerEncryptionKey customerEncryptionKey) {
        this.sourceDiskEncryptionKey = customerEncryptionKey;
        return this;
    }

    public String getSourceDiskId() {
        return this.sourceDiskId;
    }

    public Image setSourceDiskId(String string) {
        this.sourceDiskId = string;
        return this;
    }

    public String getSourceImage() {
        return this.sourceImage;
    }

    public Image setSourceImage(String string) {
        this.sourceImage = string;
        return this;
    }

    public CustomerEncryptionKey getSourceImageEncryptionKey() {
        return this.sourceImageEncryptionKey;
    }

    public Image setSourceImageEncryptionKey(CustomerEncryptionKey customerEncryptionKey) {
        this.sourceImageEncryptionKey = customerEncryptionKey;
        return this;
    }

    public String getSourceImageId() {
        return this.sourceImageId;
    }

    public Image setSourceImageId(String string) {
        this.sourceImageId = string;
        return this;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Image setSourceType(String string) {
        this.sourceType = string;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Image setStatus(String string) {
        this.status = string;
        return this;
    }

    public Image set(String string, Object object) {
        return (Image)super.set(string, object);
    }

    public Image clone() {
        return (Image)super.clone();
    }

    static {
        Data.nullOf(GuestOsFeature.class);
    }

    public static final class RawDisk
    extends GenericJson {
        @Key
        private String containerType;
        @Key
        private String sha1Checksum;
        @Key
        private String source;

        public String getContainerType() {
            return this.containerType;
        }

        public RawDisk setContainerType(String string) {
            this.containerType = string;
            return this;
        }

        public String getSha1Checksum() {
            return this.sha1Checksum;
        }

        public RawDisk setSha1Checksum(String string) {
            this.sha1Checksum = string;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public RawDisk setSource(String string) {
            this.source = string;
            return this;
        }

        public RawDisk set(String string, Object object) {
            return (RawDisk)super.set(string, object);
        }

        public RawDisk clone() {
            return (RawDisk)super.clone();
        }
    }
}

