/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-10-05 at 05:48:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NetworkEndpointWithHealthStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkEndpointWithHealthStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] The health status of network endpoint;
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HealthStatusForNetworkEndpoint> healths;

  static {
    // hack to force ProGuard to consider HealthStatusForNetworkEndpoint used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HealthStatusForNetworkEndpoint.class);
  }

  /**
   * [Output only] The network endpoint;
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkEndpoint networkEndpoint;

  /**
   * [Output only] The health status of network endpoint;
   * @return value or {@code null} for none
   */
  public java.util.List<HealthStatusForNetworkEndpoint> getHealths() {
    return healths;
  }

  /**
   * [Output only] The health status of network endpoint;
   * @param healths healths or {@code null} for none
   */
  public NetworkEndpointWithHealthStatus setHealths(java.util.List<HealthStatusForNetworkEndpoint> healths) {
    this.healths = healths;
    return this;
  }

  /**
   * [Output only] The network endpoint;
   * @return value or {@code null} for none
   */
  public NetworkEndpoint getNetworkEndpoint() {
    return networkEndpoint;
  }

  /**
   * [Output only] The network endpoint;
   * @param networkEndpoint networkEndpoint or {@code null} for none
   */
  public NetworkEndpointWithHealthStatus setNetworkEndpoint(NetworkEndpoint networkEndpoint) {
    this.networkEndpoint = networkEndpoint;
    return this;
  }

  @Override
  public NetworkEndpointWithHealthStatus set(String fieldName, Object value) {
    return (NetworkEndpointWithHealthStatus) super.set(fieldName, value);
  }

  @Override
  public NetworkEndpointWithHealthStatus clone() {
    return (NetworkEndpointWithHealthStatus) super.clone();
  }

}
