/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-10-05 at 05:48:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet
 * without external IP addresses. It specifies a list of subnetworks (and the ranges within) that
 * want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP
 * would auto-allocate ephemeral IPs if no external IPs are provided.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterNat extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] List of IPs allocated automatically by GCP for this Nat service. They will be raw
   * IP strings like "179.12.26.133". They are ephemeral IPs allocated from the IP blocks managed by
   * the NAT manager. This list can grow and shrink based on the number of VMs configured to use
   * NAT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> autoAllocatedNatIps;

  /**
   * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Specify the NatIpAllocateOption. If it is AUTO_ONLY, then nat_ip should be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String natIpAllocateOption;

  /**
   * List of URLs of the IP resources used for this Nat service. These IPs must be valid static
   * external IP addresses assigned to the project. max_length is subject to change post alpha.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> natIps;

  /**
   * Specify the Nat option. If this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or
   * ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in
   * any Router for this network in this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceSubnetworkIpRangesToNat;

  /**
   * List of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only
   * when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RouterNatSubnetworkToNat> subnetworks;

  /**
   * [Output Only] List of IPs allocated automatically by GCP for this Nat service. They will be raw
   * IP strings like "179.12.26.133". They are ephemeral IPs allocated from the IP blocks managed by
   * the NAT manager. This list can grow and shrink based on the number of VMs configured to use
   * NAT.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAutoAllocatedNatIps() {
    return autoAllocatedNatIps;
  }

  /**
   * [Output Only] List of IPs allocated automatically by GCP for this Nat service. They will be raw
   * IP strings like "179.12.26.133". They are ephemeral IPs allocated from the IP blocks managed by
   * the NAT manager. This list can grow and shrink based on the number of VMs configured to use
   * NAT.
   * @param autoAllocatedNatIps autoAllocatedNatIps or {@code null} for none
   */
  public RouterNat setAutoAllocatedNatIps(java.util.List<java.lang.String> autoAllocatedNatIps) {
    this.autoAllocatedNatIps = autoAllocatedNatIps;
    return this;
  }

  /**
   * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public RouterNat setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Specify the NatIpAllocateOption. If it is AUTO_ONLY, then nat_ip should be empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getNatIpAllocateOption() {
    return natIpAllocateOption;
  }

  /**
   * Specify the NatIpAllocateOption. If it is AUTO_ONLY, then nat_ip should be empty.
   * @param natIpAllocateOption natIpAllocateOption or {@code null} for none
   */
  public RouterNat setNatIpAllocateOption(java.lang.String natIpAllocateOption) {
    this.natIpAllocateOption = natIpAllocateOption;
    return this;
  }

  /**
   * List of URLs of the IP resources used for this Nat service. These IPs must be valid static
   * external IP addresses assigned to the project. max_length is subject to change post alpha.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNatIps() {
    return natIps;
  }

  /**
   * List of URLs of the IP resources used for this Nat service. These IPs must be valid static
   * external IP addresses assigned to the project. max_length is subject to change post alpha.
   * @param natIps natIps or {@code null} for none
   */
  public RouterNat setNatIps(java.util.List<java.lang.String> natIps) {
    this.natIps = natIps;
    return this;
  }

  /**
   * Specify the Nat option. If this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or
   * ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in
   * any Router for this network in this region.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceSubnetworkIpRangesToNat() {
    return sourceSubnetworkIpRangesToNat;
  }

  /**
   * Specify the Nat option. If this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or
   * ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in
   * any Router for this network in this region.
   * @param sourceSubnetworkIpRangesToNat sourceSubnetworkIpRangesToNat or {@code null} for none
   */
  public RouterNat setSourceSubnetworkIpRangesToNat(java.lang.String sourceSubnetworkIpRangesToNat) {
    this.sourceSubnetworkIpRangesToNat = sourceSubnetworkIpRangesToNat;
    return this;
  }

  /**
   * List of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only
   * when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * @return value or {@code null} for none
   */
  public java.util.List<RouterNatSubnetworkToNat> getSubnetworks() {
    return subnetworks;
  }

  /**
   * List of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only
   * when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * @param subnetworks subnetworks or {@code null} for none
   */
  public RouterNat setSubnetworks(java.util.List<RouterNatSubnetworkToNat> subnetworks) {
    this.subnetworks = subnetworks;
    return this;
  }

  @Override
  public RouterNat set(String fieldName, Object value) {
    return (RouterNat) super.set(fieldName, value);
  }

  @Override
  public RouterNat clone() {
    return (RouterNat) super.clone();
  }

}
