/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-10-19 at 07:31:53 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Description-tagged IP ranges for the router to advertise.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterAdvertisedIpRange extends com.google.api.client.json.GenericJson {

  /**
   * User-specified description for the IP range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The IP range to advertise. The value must be a CIDR-formatted string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String range;

  /**
   * User-specified description for the IP range.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * User-specified description for the IP range.
   * @param description description or {@code null} for none
   */
  public RouterAdvertisedIpRange setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The IP range to advertise. The value must be a CIDR-formatted string.
   * @return value or {@code null} for none
   */
  public java.lang.String getRange() {
    return range;
  }

  /**
   * The IP range to advertise. The value must be a CIDR-formatted string.
   * @param range range or {@code null} for none
   */
  public RouterAdvertisedIpRange setRange(java.lang.String range) {
    this.range = range;
    return this;
  }

  @Override
  public RouterAdvertisedIpRange set(String fieldName, Object value) {
    return (RouterAdvertisedIpRange) super.set(fieldName, value);
  }

  @Override
  public RouterAdvertisedIpRange clone() {
    return (RouterAdvertisedIpRange) super.clone();
  }

}
