/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-10-19 at 07:30:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for HealthStatusForNetworkEndpoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HealthStatusForNetworkEndpoint extends com.google.api.client.json.GenericJson {

  /**
   * URL of the backend service associated with the health state of the network endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BackendServiceReference backendService;

  /**
   * URL of the forwarding rule associated with the health state of the network endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ForwardingRuleReference forwardingRule;

  /**
   * URL of the health check associated with the health state of the network endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HealthCheckReference healthCheck;

  /**
   * Health state of the network endpoint determined based on the health checks configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthState;

  /**
   * URL of the backend service associated with the health state of the network endpoint.
   * @return value or {@code null} for none
   */
  public BackendServiceReference getBackendService() {
    return backendService;
  }

  /**
   * URL of the backend service associated with the health state of the network endpoint.
   * @param backendService backendService or {@code null} for none
   */
  public HealthStatusForNetworkEndpoint setBackendService(BackendServiceReference backendService) {
    this.backendService = backendService;
    return this;
  }

  /**
   * URL of the forwarding rule associated with the health state of the network endpoint.
   * @return value or {@code null} for none
   */
  public ForwardingRuleReference getForwardingRule() {
    return forwardingRule;
  }

  /**
   * URL of the forwarding rule associated with the health state of the network endpoint.
   * @param forwardingRule forwardingRule or {@code null} for none
   */
  public HealthStatusForNetworkEndpoint setForwardingRule(ForwardingRuleReference forwardingRule) {
    this.forwardingRule = forwardingRule;
    return this;
  }

  /**
   * URL of the health check associated with the health state of the network endpoint.
   * @return value or {@code null} for none
   */
  public HealthCheckReference getHealthCheck() {
    return healthCheck;
  }

  /**
   * URL of the health check associated with the health state of the network endpoint.
   * @param healthCheck healthCheck or {@code null} for none
   */
  public HealthStatusForNetworkEndpoint setHealthCheck(HealthCheckReference healthCheck) {
    this.healthCheck = healthCheck;
    return this;
  }

  /**
   * Health state of the network endpoint determined based on the health checks configured.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthState() {
    return healthState;
  }

  /**
   * Health state of the network endpoint determined based on the health checks configured.
   * @param healthState healthState or {@code null} for none
   */
  public HealthStatusForNetworkEndpoint setHealthState(java.lang.String healthState) {
    this.healthState = healthState;
    return this;
  }

  @Override
  public HealthStatusForNetworkEndpoint set(String fieldName, Object value) {
    return (HealthStatusForNetworkEndpoint) super.set(fieldName, value);
  }

  @Override
  public HealthStatusForNetworkEndpoint clone() {
    return (HealthStatusForNetworkEndpoint) super.clone();
  }

}
