/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-15 at 08:20:53 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration of a Cloud Function backend.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceCloudFunctionBackend extends com.google.api.client.json.GenericJson {

  /**
   * Required. A cloud function name. Special value ?*? represents all cloud functions in the
   * project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String functionName;

  /**
   * Required. Project ID of the project hosting the cloud function.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetProject;

  /**
   * Required. A cloud function name. Special value ?*? represents all cloud functions in the
   * project.
   * @return value or {@code null} for none
   */
  public java.lang.String getFunctionName() {
    return functionName;
  }

  /**
   * Required. A cloud function name. Special value ?*? represents all cloud functions in the
   * project.
   * @param functionName functionName or {@code null} for none
   */
  public BackendServiceCloudFunctionBackend setFunctionName(java.lang.String functionName) {
    this.functionName = functionName;
    return this;
  }

  /**
   * Required. Project ID of the project hosting the cloud function.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetProject() {
    return targetProject;
  }

  /**
   * Required. Project ID of the project hosting the cloud function.
   * @param targetProject targetProject or {@code null} for none
   */
  public BackendServiceCloudFunctionBackend setTargetProject(java.lang.String targetProject) {
    this.targetProject = targetProject;
    return this;
  }

  @Override
  public BackendServiceCloudFunctionBackend set(String fieldName, Object value) {
    return (BackendServiceCloudFunctionBackend) super.set(fieldName, value);
  }

  @Override
  public BackendServiceCloudFunctionBackend clone() {
    return (BackendServiceCloudFunctionBackend) super.clone();
  }

}
