/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-07 at 04:04:49 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Commitment for a particular resource (a Commitment is composed of one or more of these).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceCommitment extends com.google.api.client.json.GenericJson {

  /**
   * The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this
   * can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of
   * 256 MB, with up to 6.5GB of memory per every vCPU.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long amount;

  /**
   * Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this
   * can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of
   * 256 MB, with up to 6.5GB of memory per every vCPU.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAmount() {
    return amount;
  }

  /**
   * The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this
   * can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of
   * 256 MB, with up to 6.5GB of memory per every vCPU.
   * @param amount amount or {@code null} for none
   */
  public ResourceCommitment setAmount(java.lang.Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
   * @param type type or {@code null} for none
   */
  public ResourceCommitment setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ResourceCommitment set(String fieldName, Object value) {
    return (ResourceCommitment) super.set(fieldName, value);
  }

  @Override
  public ResourceCommitment clone() {
    return (ResourceCommitment) super.clone();
  }

}
