/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-19 at 02:07:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration parameters for scaling based on Cloud Pub/Sub subscription queue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicyQueueBasedScalingCloudPubSub extends com.google.api.client.json.GenericJson {

  /**
   * Cloud Pub/Sub subscription used for scaling. Provide the partial URL (starting with projects/)
   * or just the subscription name. The subscription must be assigned to the topic specified in
   * topicName and must be in a pull configuration. The subscription must belong to the same project
   * as the Autoscaler.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subscription;

  /**
   * Cloud Pub/Sub topic used for scaling. Provide the partial URL or partial URL (starting with
   * projects/) or just the topic name. The topic must belong to the same project as the Autoscaler
   * resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topic;

  /**
   * Cloud Pub/Sub subscription used for scaling. Provide the partial URL (starting with projects/)
   * or just the subscription name. The subscription must be assigned to the topic specified in
   * topicName and must be in a pull configuration. The subscription must belong to the same project
   * as the Autoscaler.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubscription() {
    return subscription;
  }

  /**
   * Cloud Pub/Sub subscription used for scaling. Provide the partial URL (starting with projects/)
   * or just the subscription name. The subscription must be assigned to the topic specified in
   * topicName and must be in a pull configuration. The subscription must belong to the same project
   * as the Autoscaler.
   * @param subscription subscription or {@code null} for none
   */
  public AutoscalingPolicyQueueBasedScalingCloudPubSub setSubscription(java.lang.String subscription) {
    this.subscription = subscription;
    return this;
  }

  /**
   * Cloud Pub/Sub topic used for scaling. Provide the partial URL or partial URL (starting with
   * projects/) or just the topic name. The topic must belong to the same project as the Autoscaler
   * resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopic() {
    return topic;
  }

  /**
   * Cloud Pub/Sub topic used for scaling. Provide the partial URL or partial URL (starting with
   * projects/) or just the topic name. The topic must belong to the same project as the Autoscaler
   * resource.
   * @param topic topic or {@code null} for none
   */
  public AutoscalingPolicyQueueBasedScalingCloudPubSub setTopic(java.lang.String topic) {
    this.topic = topic;
    return this;
  }

  @Override
  public AutoscalingPolicyQueueBasedScalingCloudPubSub set(String fieldName, Object value) {
    return (AutoscalingPolicyQueueBasedScalingCloudPubSub) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicyQueueBasedScalingCloudPubSub clone() {
    return (AutoscalingPolicyQueueBasedScalingCloudPubSub) super.clone();
  }

}
