/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-19 at 01:05:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to
 * perform on this VM and when.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VmMaintenancePolicy extends com.google.api.client.json.GenericJson {

  /**
   * Maintenance windows that are applied to VMs covered by this policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MaintenanceWindow maintenanceWindow;

  /**
   * Maintenance windows that are applied to VMs covered by this policy.
   * @return value or {@code null} for none
   */
  public MaintenanceWindow getMaintenanceWindow() {
    return maintenanceWindow;
  }

  /**
   * Maintenance windows that are applied to VMs covered by this policy.
   * @param maintenanceWindow maintenanceWindow or {@code null} for none
   */
  public VmMaintenancePolicy setMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
    this.maintenanceWindow = maintenanceWindow;
    return this;
  }

  @Override
  public VmMaintenancePolicy set(String fieldName, Object value) {
    return (VmMaintenancePolicy) super.set(fieldName, value);
  }

  @Override
  public VmMaintenancePolicy clone() {
    return (VmMaintenancePolicy) super.clone();
  }

}
