/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-16 at 20:04:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BackendServiceFailoverPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceFailoverPolicy extends com.google.api.client.json.GenericJson {

  /**
   * On failover or failback, this field indicates whether connection drain will be honored. Setting
   * this to true has the following effect: connections to the old active pool are not drained.
   * Connections to the new active pool use the timeout of 10 min (currently fixed). Setting to
   * false has the following effect: both old and new connections will have a drain timeout of 10
   * min.
   *
   * This can be set to true only if the protocol is TCP.
   *
   * The default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableConnectionDrainOnFailover;

  /**
   * This option is used only when no healthy VMs are detected in the primary and backup instance
   * groups. When set to true, traffic is dropped. When set to false, new connections are sent
   * across all VMs in the primary group.
   *
   * The default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dropTrafficIfUnhealthy;

  /**
   * The value of the field must be in [0, 1]. If the ratio of the healthy VMs in the primary
   * backend is at or below this number, traffic arriving at the load-balanced IP will be directed
   * to the failover backend.
   *
   * In case where 'failoverRatio' is not set or all the VMs in the backup backend are unhealthy,
   * the traffic will be directed back to the primary backend in the "force" mode, where traffic
   * will be spread to the healthy VMs with the best effort, or to all VMs when no VM is healthy.
   *
   * This field is only used with l4 load balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float failoverRatio;

  /**
   * On failover or failback, this field indicates whether connection drain will be honored. Setting
   * this to true has the following effect: connections to the old active pool are not drained.
   * Connections to the new active pool use the timeout of 10 min (currently fixed). Setting to
   * false has the following effect: both old and new connections will have a drain timeout of 10
   * min.
   *
   * This can be set to true only if the protocol is TCP.
   *
   * The default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableConnectionDrainOnFailover() {
    return disableConnectionDrainOnFailover;
  }

  /**
   * On failover or failback, this field indicates whether connection drain will be honored. Setting
   * this to true has the following effect: connections to the old active pool are not drained.
   * Connections to the new active pool use the timeout of 10 min (currently fixed). Setting to
   * false has the following effect: both old and new connections will have a drain timeout of 10
   * min.
   *
   * This can be set to true only if the protocol is TCP.
   *
   * The default is false.
   * @param disableConnectionDrainOnFailover disableConnectionDrainOnFailover or {@code null} for none
   */
  public BackendServiceFailoverPolicy setDisableConnectionDrainOnFailover(java.lang.Boolean disableConnectionDrainOnFailover) {
    this.disableConnectionDrainOnFailover = disableConnectionDrainOnFailover;
    return this;
  }

  /**
   * This option is used only when no healthy VMs are detected in the primary and backup instance
   * groups. When set to true, traffic is dropped. When set to false, new connections are sent
   * across all VMs in the primary group.
   *
   * The default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDropTrafficIfUnhealthy() {
    return dropTrafficIfUnhealthy;
  }

  /**
   * This option is used only when no healthy VMs are detected in the primary and backup instance
   * groups. When set to true, traffic is dropped. When set to false, new connections are sent
   * across all VMs in the primary group.
   *
   * The default is false.
   * @param dropTrafficIfUnhealthy dropTrafficIfUnhealthy or {@code null} for none
   */
  public BackendServiceFailoverPolicy setDropTrafficIfUnhealthy(java.lang.Boolean dropTrafficIfUnhealthy) {
    this.dropTrafficIfUnhealthy = dropTrafficIfUnhealthy;
    return this;
  }

  /**
   * The value of the field must be in [0, 1]. If the ratio of the healthy VMs in the primary
   * backend is at or below this number, traffic arriving at the load-balanced IP will be directed
   * to the failover backend.
   *
   * In case where 'failoverRatio' is not set or all the VMs in the backup backend are unhealthy,
   * the traffic will be directed back to the primary backend in the "force" mode, where traffic
   * will be spread to the healthy VMs with the best effort, or to all VMs when no VM is healthy.
   *
   * This field is only used with l4 load balancing.
   * @return value or {@code null} for none
   */
  public java.lang.Float getFailoverRatio() {
    return failoverRatio;
  }

  /**
   * The value of the field must be in [0, 1]. If the ratio of the healthy VMs in the primary
   * backend is at or below this number, traffic arriving at the load-balanced IP will be directed
   * to the failover backend.
   *
   * In case where 'failoverRatio' is not set or all the VMs in the backup backend are unhealthy,
   * the traffic will be directed back to the primary backend in the "force" mode, where traffic
   * will be spread to the healthy VMs with the best effort, or to all VMs when no VM is healthy.
   *
   * This field is only used with l4 load balancing.
   * @param failoverRatio failoverRatio or {@code null} for none
   */
  public BackendServiceFailoverPolicy setFailoverRatio(java.lang.Float failoverRatio) {
    this.failoverRatio = failoverRatio;
    return this;
  }

  @Override
  public BackendServiceFailoverPolicy set(String fieldName, Object value) {
    return (BackendServiceFailoverPolicy) super.set(fieldName, value);
  }

  @Override
  public BackendServiceFailoverPolicy clone() {
    return (BackendServiceFailoverPolicy) super.clone();
  }

}
