/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-17 at 01:12:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a customer-supplied Signing Key used by Cloud CDN Signed URLs
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SignedUrlKey extends com.google.api.client.json.GenericJson {

  /**
   * Name of the key. The name must be 1-63 characters long, and comply with RFC1035. Specifically,
   * the name must be 1-63 characters long and match the regular expression
   * [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all
   * following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyName;

  /**
   * 128-bit key value used for signing the URL. The key value must be a valid RFC 4648 Section 5
   * base64url encoded string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyValue;

  /**
   * Name of the key. The name must be 1-63 characters long, and comply with RFC1035. Specifically,
   * the name must be 1-63 characters long and match the regular expression
   * [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all
   * following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyName() {
    return keyName;
  }

  /**
   * Name of the key. The name must be 1-63 characters long, and comply with RFC1035. Specifically,
   * the name must be 1-63 characters long and match the regular expression
   * [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all
   * following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @param keyName keyName or {@code null} for none
   */
  public SignedUrlKey setKeyName(java.lang.String keyName) {
    this.keyName = keyName;
    return this;
  }

  /**
   * 128-bit key value used for signing the URL. The key value must be a valid RFC 4648 Section 5
   * base64url encoded string.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyValue() {
    return keyValue;
  }

  /**
   * 128-bit key value used for signing the URL. The key value must be a valid RFC 4648 Section 5
   * base64url encoded string.
   * @param keyValue keyValue or {@code null} for none
   */
  public SignedUrlKey setKeyValue(java.lang.String keyValue) {
    this.keyValue = keyValue;
    return this;
  }

  @Override
  public SignedUrlKey set(String fieldName, Object value) {
    return (SignedUrlKey) super.set(fieldName, value);
  }

  @Override
  public SignedUrlKey clone() {
    return (SignedUrlKey) super.clone();
  }

}
