/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-01 at 05:52:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InternalIpOwner.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InternalIpOwner extends com.google.api.client.json.GenericJson {

  /**
   * IP CIDR range being owned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCidrRange;

  /**
   * URLs of the IP owners of the IP CIDR range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> owners;

  /**
   * Whether this IP CIDR range is reserved for system use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean systemOwned;

  /**
   * IP CIDR range being owned.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCidrRange() {
    return ipCidrRange;
  }

  /**
   * IP CIDR range being owned.
   * @param ipCidrRange ipCidrRange or {@code null} for none
   */
  public InternalIpOwner setIpCidrRange(java.lang.String ipCidrRange) {
    this.ipCidrRange = ipCidrRange;
    return this;
  }

  /**
   * URLs of the IP owners of the IP CIDR range.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOwners() {
    return owners;
  }

  /**
   * URLs of the IP owners of the IP CIDR range.
   * @param owners owners or {@code null} for none
   */
  public InternalIpOwner setOwners(java.util.List<java.lang.String> owners) {
    this.owners = owners;
    return this;
  }

  /**
   * Whether this IP CIDR range is reserved for system use.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSystemOwned() {
    return systemOwned;
  }

  /**
   * Whether this IP CIDR range is reserved for system use.
   * @param systemOwned systemOwned or {@code null} for none
   */
  public InternalIpOwner setSystemOwned(java.lang.Boolean systemOwned) {
    this.systemOwned = systemOwned;
    return this;
  }

  @Override
  public InternalIpOwner set(String fieldName, Object value) {
    return (InternalIpOwner) super.set(fieldName, value);
  }

  @Override
  public InternalIpOwner clone() {
    return (InternalIpOwner) super.clone();
  }

}
