/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-15 at 15:23:51 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RegionSetLabelsRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionSetLabelsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The
   * fingerprint is initially generated by Compute Engine and changes after every request to modify
   * or update labels. You must always provide an up-to-date fingerprint hash in order to update or
   * change labels. Make a get() request to the resource to get the latest fingerprint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelFingerprint;

  /**
   * The labels to set for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The
   * fingerprint is initially generated by Compute Engine and changes after every request to modify
   * or update labels. You must always provide an up-to-date fingerprint hash in order to update or
   * change labels. Make a get() request to the resource to get the latest fingerprint.
   * @see #decodeLabelFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelFingerprint() {
    return labelFingerprint;
  }

  /**
   * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The
   * fingerprint is initially generated by Compute Engine and changes after every request to modify
   * or update labels. You must always provide an up-to-date fingerprint hash in order to update or
   * change labels. Make a get() request to the resource to get the latest fingerprint.
   * @see #getLabelFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeLabelFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(labelFingerprint);
  }

  /**
   * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The
   * fingerprint is initially generated by Compute Engine and changes after every request to modify
   * or update labels. You must always provide an up-to-date fingerprint hash in order to update or
   * change labels. Make a get() request to the resource to get the latest fingerprint.
   * @see #encodeLabelFingerprint()
   * @param labelFingerprint labelFingerprint or {@code null} for none
   */
  public RegionSetLabelsRequest setLabelFingerprint(java.lang.String labelFingerprint) {
    this.labelFingerprint = labelFingerprint;
    return this;
  }

  /**
   * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The
   * fingerprint is initially generated by Compute Engine and changes after every request to modify
   * or update labels. You must always provide an up-to-date fingerprint hash in order to update or
   * change labels. Make a get() request to the resource to get the latest fingerprint.
   * @see #setLabelFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public RegionSetLabelsRequest encodeLabelFingerprint(byte[] labelFingerprint) {
    this.labelFingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(labelFingerprint);
    return this;
  }

  /**
   * The labels to set for this resource.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * The labels to set for this resource.
   * @param labels labels or {@code null} for none
   */
  public RegionSetLabelsRequest setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public RegionSetLabelsRequest set(String fieldName, Object value) {
    return (RegionSetLabelsRequest) super.set(fieldName, value);
  }

  @Override
  public RegionSetLabelsRequest clone() {
    return (RegionSetLabelsRequest) super.clone();
  }

}
