/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-15 at 18:33:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ManagedInstanceLastAttempt.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedInstanceLastAttempt extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Encountered errors during the last attempt to create or delete the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Errors errors;

  /**
   * [Output Only] Encountered errors during the last attempt to create or delete the instance.
   * @return value or {@code null} for none
   */
  public Errors getErrors() {
    return errors;
  }

  /**
   * [Output Only] Encountered errors during the last attempt to create or delete the instance.
   * @param errors errors or {@code null} for none
   */
  public ManagedInstanceLastAttempt setErrors(Errors errors) {
    this.errors = errors;
    return this;
  }

  @Override
  public ManagedInstanceLastAttempt set(String fieldName, Object value) {
    return (ManagedInstanceLastAttempt) super.set(fieldName, value);
  }

  @Override
  public ManagedInstanceLastAttempt clone() {
    return (ManagedInstanceLastAttempt) super.clone();
  }

  /**
   * [Output Only] Encountered errors during the last attempt to create or delete the instance.
   */
  public static final class Errors extends com.google.api.client.json.GenericJson {

    /**
     * [Output Only] The array of errors encountered while processing this operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<ManagedInstanceLastAttemptErrorsErrors> errors;

    static {
      // hack to force ProGuard to consider ManagedInstanceLastAttemptErrorsErrors used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(ManagedInstanceLastAttemptErrorsErrors.class);
    }

    /**
     * [Output Only] The array of errors encountered while processing this operation.
     * @return value or {@code null} for none
     */
    public java.util.List<ManagedInstanceLastAttemptErrorsErrors> getErrors() {
      return errors;
    }

    /**
     * [Output Only] The array of errors encountered while processing this operation.
     * @param errors errors or {@code null} for none
     */
    public Errors setErrors(java.util.List<ManagedInstanceLastAttemptErrorsErrors> errors) {
      this.errors = errors;
      return this;
    }

    @Override
    public Errors set(String fieldName, Object value) {
      return (Errors) super.set(fieldName, value);
    }

    @Override
    public Errors clone() {
      return (Errors) super.clone();
    }

    /**
     * Model definition for ManagedInstanceLastAttemptErrorsErrors.
     */
    public static final class ManagedInstanceLastAttemptErrorsErrors extends com.google.api.client.json.GenericJson {

      /**
       * [Output Only] The error type identifier for this error.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String code;

      /**
       * [Output Only] Indicates the field in the request that caused the error. This property is
       * optional.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /**
       * [Output Only] An optional, human-readable error message.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String message;

      /**
       * [Output Only] The error type identifier for this error.
       * @return value or {@code null} for none
       */
      public java.lang.String getCode() {
        return code;
      }

      /**
       * [Output Only] The error type identifier for this error.
       * @param code code or {@code null} for none
       */
      public ManagedInstanceLastAttemptErrorsErrors setCode(java.lang.String code) {
        this.code = code;
        return this;
      }

      /**
       * [Output Only] Indicates the field in the request that caused the error. This property is
       * optional.
       * @return value or {@code null} for none
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * [Output Only] Indicates the field in the request that caused the error. This property is
       * optional.
       * @param location location or {@code null} for none
       */
      public ManagedInstanceLastAttemptErrorsErrors setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /**
       * [Output Only] An optional, human-readable error message.
       * @return value or {@code null} for none
       */
      public java.lang.String getMessage() {
        return message;
      }

      /**
       * [Output Only] An optional, human-readable error message.
       * @param message message or {@code null} for none
       */
      public ManagedInstanceLastAttemptErrorsErrors setMessage(java.lang.String message) {
        this.message = message;
        return this;
      }

      @Override
      public ManagedInstanceLastAttemptErrorsErrors set(String fieldName, Object value) {
        return (ManagedInstanceLastAttemptErrorsErrors) super.set(fieldName, value);
      }

      @Override
      public ManagedInstanceLastAttemptErrorsErrors clone() {
        return (ManagedInstanceLastAttemptErrorsErrors) super.clone();
      }

    }
  }
}
