/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-15 at 18:33:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will
 * serve the URL. If no rule was matched, the default service will be used.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PathMatcher extends com.google.api.client.json.GenericJson {

  /**
   * The full or partial URL to the BackendService resource. This will be used if none of the
   * pathRules defined by this PathMatcher is matched by the URL's path portion. For example, the
   * following are all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService  -
   * compute/v1/projects/project/global/backendServices/backendService  -
   * global/backendServices/backendService
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultService;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The list of path rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PathRule> pathRules;

  /**
   * The full or partial URL to the BackendService resource. This will be used if none of the
   * pathRules defined by this PathMatcher is matched by the URL's path portion. For example, the
   * following are all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService  -
   * compute/v1/projects/project/global/backendServices/backendService  -
   * global/backendServices/backendService
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultService() {
    return defaultService;
  }

  /**
   * The full or partial URL to the BackendService resource. This will be used if none of the
   * pathRules defined by this PathMatcher is matched by the URL's path portion. For example, the
   * following are all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService  -
   * compute/v1/projects/project/global/backendServices/backendService  -
   * global/backendServices/backendService
   * @param defaultService defaultService or {@code null} for none
   */
  public PathMatcher setDefaultService(java.lang.String defaultService) {
    this.defaultService = defaultService;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public PathMatcher setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * @param name name or {@code null} for none
   */
  public PathMatcher setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The list of path rules.
   * @return value or {@code null} for none
   */
  public java.util.List<PathRule> getPathRules() {
    return pathRules;
  }

  /**
   * The list of path rules.
   * @param pathRules pathRules or {@code null} for none
   */
  public PathMatcher setPathRules(java.util.List<PathRule> pathRules) {
    this.pathRules = pathRules;
    return this;
  }

  @Override
  public PathMatcher set(String fieldName, Object value) {
    return (PathMatcher) super.set(fieldName, value);
  }

  @Override
  public PathMatcher clone() {
    return (PathMatcher) super.clone();
  }

}
