/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-05 at 18:18:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a secondary IP range of a subnetwork.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubnetworkSecondaryRange extends com.google.api.client.json.GenericJson {

  /**
   * The range of IP addresses belonging to this subnetwork secondary range. Provide this property
   * when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and
   * secondary IP ranges within a network. Only IPv4 is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCidrRange;

  /**
   * The name associated with this subnetwork secondary range, used when adding an alias IP range to
   * a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be
   * unique within the subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rangeName;

  /**
   * The range of IP addresses belonging to this subnetwork secondary range. Provide this property
   * when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and
   * secondary IP ranges within a network. Only IPv4 is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCidrRange() {
    return ipCidrRange;
  }

  /**
   * The range of IP addresses belonging to this subnetwork secondary range. Provide this property
   * when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and
   * secondary IP ranges within a network. Only IPv4 is supported.
   * @param ipCidrRange ipCidrRange or {@code null} for none
   */
  public SubnetworkSecondaryRange setIpCidrRange(java.lang.String ipCidrRange) {
    this.ipCidrRange = ipCidrRange;
    return this;
  }

  /**
   * The name associated with this subnetwork secondary range, used when adding an alias IP range to
   * a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be
   * unique within the subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getRangeName() {
    return rangeName;
  }

  /**
   * The name associated with this subnetwork secondary range, used when adding an alias IP range to
   * a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be
   * unique within the subnetwork.
   * @param rangeName rangeName or {@code null} for none
   */
  public SubnetworkSecondaryRange setRangeName(java.lang.String rangeName) {
    this.rangeName = rangeName;
    return this;
  }

  @Override
  public SubnetworkSecondaryRange set(String fieldName, Object value) {
    return (SubnetworkSecondaryRange) super.set(fieldName, value);
  }

  @Override
  public SubnetworkSecondaryRange clone() {
    return (SubnetworkSecondaryRange) super.clone();
  }

}
