/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-05 at 21:32:59 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A maintenance window for VMs and disks. When set, we restrict our maintenance operations to this
 * window.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MaintenanceWindow extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DailyMaintenanceWindow dailyMaintenanceWindow;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HourlyMaintenanceWindow hourlyMaintenanceWindow;

  /**
   * @return value or {@code null} for none
   */
  public DailyMaintenanceWindow getDailyMaintenanceWindow() {
    return dailyMaintenanceWindow;
  }

  /**
   * @param dailyMaintenanceWindow dailyMaintenanceWindow or {@code null} for none
   */
  public MaintenanceWindow setDailyMaintenanceWindow(DailyMaintenanceWindow dailyMaintenanceWindow) {
    this.dailyMaintenanceWindow = dailyMaintenanceWindow;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public HourlyMaintenanceWindow getHourlyMaintenanceWindow() {
    return hourlyMaintenanceWindow;
  }

  /**
   * @param hourlyMaintenanceWindow hourlyMaintenanceWindow or {@code null} for none
   */
  public MaintenanceWindow setHourlyMaintenanceWindow(HourlyMaintenanceWindow hourlyMaintenanceWindow) {
    this.hourlyMaintenanceWindow = hourlyMaintenanceWindow;
    return this;
  }

  @Override
  public MaintenanceWindow set(String fieldName, Object value) {
    return (MaintenanceWindow) super.set(fieldName, value);
  }

  @Override
  public MaintenanceWindow clone() {
    return (MaintenanceWindow) super.clone();
  }

}
