/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-04-06 17:52:19 UTC)
 * on 2018-04-21 at 05:06:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Description of a planned outage on this Interconnect. Next id: 9
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectOutageNotification extends com.google.api.client.json.GenericJson {

  /**
   * Iff issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be
   * affected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> affectedCircuits;

  /**
   * A description about the purpose of the outage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long endTime;

  /**
   * Form this outage is expected to take. Note that the "IT_" versions of this enum have been
   * deprecated in favor of the unprefixed values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issueType;

  /**
   * Unique identifier for this outage notification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The party that generated this notification. Note that "NSRC_GOOGLE" has been deprecated in
   * favor of "GOOGLE"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long startTime;

  /**
   * State of this notification. Note that the "NS_" versions of this enum have been deprecated in
   * favor of the unprefixed values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Iff issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be
   * affected.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAffectedCircuits() {
    return affectedCircuits;
  }

  /**
   * Iff issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be
   * affected.
   * @param affectedCircuits affectedCircuits or {@code null} for none
   */
  public InterconnectOutageNotification setAffectedCircuits(java.util.List<java.lang.String> affectedCircuits) {
    this.affectedCircuits = affectedCircuits;
    return this;
  }

  /**
   * A description about the purpose of the outage.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A description about the purpose of the outage.
   * @param description description or {@code null} for none
   */
  public InterconnectOutageNotification setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   * @return value or {@code null} for none
   */
  public java.lang.Long getEndTime() {
    return endTime;
  }

  /**
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   * @param endTime endTime or {@code null} for none
   */
  public InterconnectOutageNotification setEndTime(java.lang.Long endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Form this outage is expected to take. Note that the "IT_" versions of this enum have been
   * deprecated in favor of the unprefixed values.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssueType() {
    return issueType;
  }

  /**
   * Form this outage is expected to take. Note that the "IT_" versions of this enum have been
   * deprecated in favor of the unprefixed values.
   * @param issueType issueType or {@code null} for none
   */
  public InterconnectOutageNotification setIssueType(java.lang.String issueType) {
    this.issueType = issueType;
    return this;
  }

  /**
   * Unique identifier for this outage notification.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Unique identifier for this outage notification.
   * @param name name or {@code null} for none
   */
  public InterconnectOutageNotification setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The party that generated this notification. Note that "NSRC_GOOGLE" has been deprecated in
   * favor of "GOOGLE"
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The party that generated this notification. Note that "NSRC_GOOGLE" has been deprecated in
   * favor of "GOOGLE"
   * @param source source or {@code null} for none
   */
  public InterconnectOutageNotification setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   * @return value or {@code null} for none
   */
  public java.lang.Long getStartTime() {
    return startTime;
  }

  /**
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   * @param startTime startTime or {@code null} for none
   */
  public InterconnectOutageNotification setStartTime(java.lang.Long startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * State of this notification. Note that the "NS_" versions of this enum have been deprecated in
   * favor of the unprefixed values.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * State of this notification. Note that the "NS_" versions of this enum have been deprecated in
   * favor of the unprefixed values.
   * @param state state or {@code null} for none
   */
  public InterconnectOutageNotification setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public InterconnectOutageNotification set(String fieldName, Object value) {
    return (InterconnectOutageNotification) super.set(fieldName, value);
  }

  @Override
  public InterconnectOutageNotification clone() {
    return (InterconnectOutageNotification) super.clone();
  }

}
