/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-11 at 19:08:56 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Defines the IP ranges that want to use NAT for a subnetwork.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterNatSubnetworkToNat extends com.google.api.client.json.GenericJson {

  /**
   * URL for the subnetwork resource to use NAT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be
   * populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in
   * source_ip_ranges_to_nat.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> secondaryIpRangeNames;

  /**
   * Specify the options for NAT ranges in the Subnetwork. All usages of single value are valid
   * except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is:
   * ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sourceIpRangesToNats;

  /**
   * URL for the subnetwork resource to use NAT.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * URL for the subnetwork resource to use NAT.
   * @param name name or {@code null} for none
   */
  public RouterNatSubnetworkToNat setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be
   * populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in
   * source_ip_ranges_to_nat.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSecondaryIpRangeNames() {
    return secondaryIpRangeNames;
  }

  /**
   * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be
   * populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in
   * source_ip_ranges_to_nat.
   * @param secondaryIpRangeNames secondaryIpRangeNames or {@code null} for none
   */
  public RouterNatSubnetworkToNat setSecondaryIpRangeNames(java.util.List<java.lang.String> secondaryIpRangeNames) {
    this.secondaryIpRangeNames = secondaryIpRangeNames;
    return this;
  }

  /**
   * Specify the options for NAT ranges in the Subnetwork. All usages of single value are valid
   * except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is:
   * ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSourceIpRangesToNats() {
    return sourceIpRangesToNats;
  }

  /**
   * Specify the options for NAT ranges in the Subnetwork. All usages of single value are valid
   * except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is:
   * ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
   * @param sourceIpRangesToNats sourceIpRangesToNats or {@code null} for none
   */
  public RouterNatSubnetworkToNat setSourceIpRangesToNats(java.util.List<java.lang.String> sourceIpRangesToNats) {
    this.sourceIpRangesToNats = sourceIpRangesToNats;
    return this;
  }

  @Override
  public RouterNatSubnetworkToNat set(String fieldName, Object value) {
    return (RouterNatSubnetworkToNat) super.set(fieldName, value);
  }

  @Override
  public RouterNatSubnetworkToNat clone() {
    return (RouterNatSubnetworkToNat) super.clone();
  }

}
