/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-11 at 19:08:56 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Sets the scheduling options for an Instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Scheduling extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether the instance should be automatically restarted if it is terminated by Compute
   * Engine (not terminated by a user). You can only set the automatic restart option for standard
   * instances. Preemptible instances cannot be automatically restarted.
   *
   * By default, this is set to true so an instance is automatically restarted if it is terminated
   * by Compute Engine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean automaticRestart;

  /**
   * A set of node affinity and anti-affinity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SchedulingNodeAffinity> nodeAffinities;

  /**
   * Defines the maintenance behavior for this instance. For standard instances, the default
   * behavior is MIGRATE. For preemptible instances, the default and only possible behavior is
   * TERMINATE. For more information, see Setting Instance Scheduling Options.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String onHostMaintenance;

  /**
   * Defines whether the instance is preemptible. This can only be set during instance creation, it
   * cannot be set or changed after the instance has been created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean preemptible;

  /**
   * Specifies whether the instance should be automatically restarted if it is terminated by Compute
   * Engine (not terminated by a user). You can only set the automatic restart option for standard
   * instances. Preemptible instances cannot be automatically restarted.
   *
   * By default, this is set to true so an instance is automatically restarted if it is terminated
   * by Compute Engine.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutomaticRestart() {
    return automaticRestart;
  }

  /**
   * Specifies whether the instance should be automatically restarted if it is terminated by Compute
   * Engine (not terminated by a user). You can only set the automatic restart option for standard
   * instances. Preemptible instances cannot be automatically restarted.
   *
   * By default, this is set to true so an instance is automatically restarted if it is terminated
   * by Compute Engine.
   * @param automaticRestart automaticRestart or {@code null} for none
   */
  public Scheduling setAutomaticRestart(java.lang.Boolean automaticRestart) {
    this.automaticRestart = automaticRestart;
    return this;
  }

  /**
   * A set of node affinity and anti-affinity.
   * @return value or {@code null} for none
   */
  public java.util.List<SchedulingNodeAffinity> getNodeAffinities() {
    return nodeAffinities;
  }

  /**
   * A set of node affinity and anti-affinity.
   * @param nodeAffinities nodeAffinities or {@code null} for none
   */
  public Scheduling setNodeAffinities(java.util.List<SchedulingNodeAffinity> nodeAffinities) {
    this.nodeAffinities = nodeAffinities;
    return this;
  }

  /**
   * Defines the maintenance behavior for this instance. For standard instances, the default
   * behavior is MIGRATE. For preemptible instances, the default and only possible behavior is
   * TERMINATE. For more information, see Setting Instance Scheduling Options.
   * @return value or {@code null} for none
   */
  public java.lang.String getOnHostMaintenance() {
    return onHostMaintenance;
  }

  /**
   * Defines the maintenance behavior for this instance. For standard instances, the default
   * behavior is MIGRATE. For preemptible instances, the default and only possible behavior is
   * TERMINATE. For more information, see Setting Instance Scheduling Options.
   * @param onHostMaintenance onHostMaintenance or {@code null} for none
   */
  public Scheduling setOnHostMaintenance(java.lang.String onHostMaintenance) {
    this.onHostMaintenance = onHostMaintenance;
    return this;
  }

  /**
   * Defines whether the instance is preemptible. This can only be set during instance creation, it
   * cannot be set or changed after the instance has been created.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPreemptible() {
    return preemptible;
  }

  /**
   * Defines whether the instance is preemptible. This can only be set during instance creation, it
   * cannot be set or changed after the instance has been created.
   * @param preemptible preemptible or {@code null} for none
   */
  public Scheduling setPreemptible(java.lang.Boolean preemptible) {
    this.preemptible = preemptible;
    return this;
  }

  @Override
  public Scheduling set(String fieldName, Object value) {
    return (Scheduling) super.set(fieldName, value);
  }

  @Override
  public Scheduling clone() {
    return (Scheduling) super.clone();
  }

}
