/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-18 at 16:46:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Specified snapshot properties for automatic snapshots created by this policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyBackupSchedulePolicySnapshotProperties extends com.google.api.client.json.GenericJson {

  /**
   * Indication to perform a ?guest aware? snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean guestFlush;

  /**
   * Labels to apply to automatic snapshots. These can be later modified by the setLabels method.
   * Label values may be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Indication to perform a ?guest aware? snapshot.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getGuestFlush() {
    return guestFlush;
  }

  /**
   * Indication to perform a ?guest aware? snapshot.
   * @param guestFlush guestFlush or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicySnapshotProperties setGuestFlush(java.lang.Boolean guestFlush) {
    this.guestFlush = guestFlush;
    return this;
  }

  /**
   * Labels to apply to automatic snapshots. These can be later modified by the setLabels method.
   * Label values may be empty.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels to apply to automatic snapshots. These can be later modified by the setLabels method.
   * Label values may be empty.
   * @param labels labels or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicySnapshotProperties setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public ResourcePolicyBackupSchedulePolicySnapshotProperties set(String fieldName, Object value) {
    return (ResourcePolicyBackupSchedulePolicySnapshotProperties) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyBackupSchedulePolicySnapshotProperties clone() {
    return (ResourcePolicyBackupSchedulePolicySnapshotProperties) super.clone();
  }

}
