/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-18 at 15:06:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A set of Shielded VM options.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShieldedVmConfig extends com.google.api.client.json.GenericJson {

  /**
   * Defines whether the instance should have integrity monitoring enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableIntegrityMonitoring;

  /**
   * Defines whether the instance should have secure boot enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSecureBoot;

  /**
   * Defines whether the instance should have the TPM enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableVtpm;

  /**
   * Defines whether the instance should have integrity monitoring enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableIntegrityMonitoring() {
    return enableIntegrityMonitoring;
  }

  /**
   * Defines whether the instance should have integrity monitoring enabled.
   * @param enableIntegrityMonitoring enableIntegrityMonitoring or {@code null} for none
   */
  public ShieldedVmConfig setEnableIntegrityMonitoring(java.lang.Boolean enableIntegrityMonitoring) {
    this.enableIntegrityMonitoring = enableIntegrityMonitoring;
    return this;
  }

  /**
   * Defines whether the instance should have secure boot enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSecureBoot() {
    return enableSecureBoot;
  }

  /**
   * Defines whether the instance should have secure boot enabled.
   * @param enableSecureBoot enableSecureBoot or {@code null} for none
   */
  public ShieldedVmConfig setEnableSecureBoot(java.lang.Boolean enableSecureBoot) {
    this.enableSecureBoot = enableSecureBoot;
    return this;
  }

  /**
   * Defines whether the instance should have the TPM enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableVtpm() {
    return enableVtpm;
  }

  /**
   * Defines whether the instance should have the TPM enabled.
   * @param enableVtpm enableVtpm or {@code null} for none
   */
  public ShieldedVmConfig setEnableVtpm(java.lang.Boolean enableVtpm) {
    this.enableVtpm = enableVtpm;
    return this;
  }

  @Override
  public ShieldedVmConfig set(String fieldName, Object value) {
    return (ShieldedVmConfig) super.set(fieldName, value);
  }

  @Override
  public ShieldedVmConfig clone() {
    return (ShieldedVmConfig) super.clone();
  }

}
