/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-02 at 13:27:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Status of a NAT contained in this router.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterStatusNatStatus extends com.google.api.client.json.GenericJson {

  /**
   * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> autoAllocatedNatIps;

  /**
   * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are
   * NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-
   * allocation of NAT IPs is *not* used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minExtraNatIpsNeeded;

  /**
   * Unique name of this NAT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Number of VM endpoints (i.e., Nics) that can use NAT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numVmEndpointsWithNatMappings;

  /**
   * A list of fully qualified URLs of reserved IP address resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> userAllocatedNatIpResources;

  /**
   * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> userAllocatedNatIps;

  /**
   * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAutoAllocatedNatIps() {
    return autoAllocatedNatIps;
  }

  /**
   * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
   * @param autoAllocatedNatIps autoAllocatedNatIps or {@code null} for none
   */
  public RouterStatusNatStatus setAutoAllocatedNatIps(java.util.List<java.lang.String> autoAllocatedNatIps) {
    this.autoAllocatedNatIps = autoAllocatedNatIps;
    return this;
  }

  /**
   * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are
   * NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-
   * allocation of NAT IPs is *not* used.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinExtraNatIpsNeeded() {
    return minExtraNatIpsNeeded;
  }

  /**
   * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are
   * NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-
   * allocation of NAT IPs is *not* used.
   * @param minExtraNatIpsNeeded minExtraNatIpsNeeded or {@code null} for none
   */
  public RouterStatusNatStatus setMinExtraNatIpsNeeded(java.lang.Integer minExtraNatIpsNeeded) {
    this.minExtraNatIpsNeeded = minExtraNatIpsNeeded;
    return this;
  }

  /**
   * Unique name of this NAT.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Unique name of this NAT.
   * @param name name or {@code null} for none
   */
  public RouterStatusNatStatus setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Number of VM endpoints (i.e., Nics) that can use NAT.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumVmEndpointsWithNatMappings() {
    return numVmEndpointsWithNatMappings;
  }

  /**
   * Number of VM endpoints (i.e., Nics) that can use NAT.
   * @param numVmEndpointsWithNatMappings numVmEndpointsWithNatMappings or {@code null} for none
   */
  public RouterStatusNatStatus setNumVmEndpointsWithNatMappings(java.lang.Integer numVmEndpointsWithNatMappings) {
    this.numVmEndpointsWithNatMappings = numVmEndpointsWithNatMappings;
    return this;
  }

  /**
   * A list of fully qualified URLs of reserved IP address resources.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUserAllocatedNatIpResources() {
    return userAllocatedNatIpResources;
  }

  /**
   * A list of fully qualified URLs of reserved IP address resources.
   * @param userAllocatedNatIpResources userAllocatedNatIpResources or {@code null} for none
   */
  public RouterStatusNatStatus setUserAllocatedNatIpResources(java.util.List<java.lang.String> userAllocatedNatIpResources) {
    this.userAllocatedNatIpResources = userAllocatedNatIpResources;
    return this;
  }

  /**
   * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUserAllocatedNatIps() {
    return userAllocatedNatIps;
  }

  /**
   * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
   * @param userAllocatedNatIps userAllocatedNatIps or {@code null} for none
   */
  public RouterStatusNatStatus setUserAllocatedNatIps(java.util.List<java.lang.String> userAllocatedNatIps) {
    this.userAllocatedNatIps = userAllocatedNatIps;
    return this;
  }

  @Override
  public RouterStatusNatStatus set(String fieldName, Object value) {
    return (RouterStatusNatStatus) super.set(fieldName, value);
  }

  @Override
  public RouterStatusNatStatus clone() {
    return (RouterStatusNatStatus) super.clone();
  }

}
