/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-20 at 01:33:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ManagedInstanceOverrideDiskOverride.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedInstanceOverrideDiskOverride extends com.google.api.client.json.GenericJson {

  /**
   * The name of the device on the VM
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceName;

  /**
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the
   * default is to attach the disk in READ_WRITE mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * The disk that is/will be mounted
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * The name of the device on the VM
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceName() {
    return deviceName;
  }

  /**
   * The name of the device on the VM
   * @param deviceName deviceName or {@code null} for none
   */
  public ManagedInstanceOverrideDiskOverride setDeviceName(java.lang.String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

  /**
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the
   * default is to attach the disk in READ_WRITE mode.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the
   * default is to attach the disk in READ_WRITE mode.
   * @param mode mode or {@code null} for none
   */
  public ManagedInstanceOverrideDiskOverride setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * The disk that is/will be mounted
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The disk that is/will be mounted
   * @param source source or {@code null} for none
   */
  public ManagedInstanceOverrideDiskOverride setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  @Override
  public ManagedInstanceOverrideDiskOverride set(String fieldName, Object value) {
    return (ManagedInstanceOverrideDiskOverride) super.set(fieldName, value);
  }

  @Override
  public ManagedInstanceOverrideDiskOverride clone() {
    return (ManagedInstanceOverrideDiskOverride) super.clone();
  }

}
