/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-20 at 01:31:39 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NetworksAddPeeringRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworksAddPeeringRequest extends com.google.api.client.json.GenericJson {

  /**
   * Whether Google Compute Engine manages the routes automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoCreateRoutes;

  /**
   * Whether to export the custom routes to peer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean exportCustomRoutes;

  /**
   * Whether to import the custom routes from peer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean importCustomRoutes;

  /**
   * Name of the peering, which should conform to RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of the peer network. It can be either full URL or partial URL. The peer network may belong
   * to a different project. If the partial URL does not contain project, it is assumed that the
   * peer network is in the same project as the current network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String peerNetwork;

  /**
   * Whether Google Compute Engine manages the routes automatically.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoCreateRoutes() {
    return autoCreateRoutes;
  }

  /**
   * Whether Google Compute Engine manages the routes automatically.
   * @param autoCreateRoutes autoCreateRoutes or {@code null} for none
   */
  public NetworksAddPeeringRequest setAutoCreateRoutes(java.lang.Boolean autoCreateRoutes) {
    this.autoCreateRoutes = autoCreateRoutes;
    return this;
  }

  /**
   * Whether to export the custom routes to peer network.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExportCustomRoutes() {
    return exportCustomRoutes;
  }

  /**
   * Whether to export the custom routes to peer network.
   * @param exportCustomRoutes exportCustomRoutes or {@code null} for none
   */
  public NetworksAddPeeringRequest setExportCustomRoutes(java.lang.Boolean exportCustomRoutes) {
    this.exportCustomRoutes = exportCustomRoutes;
    return this;
  }

  /**
   * Whether to import the custom routes from peer network.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getImportCustomRoutes() {
    return importCustomRoutes;
  }

  /**
   * Whether to import the custom routes from peer network.
   * @param importCustomRoutes importCustomRoutes or {@code null} for none
   */
  public NetworksAddPeeringRequest setImportCustomRoutes(java.lang.Boolean importCustomRoutes) {
    this.importCustomRoutes = importCustomRoutes;
    return this;
  }

  /**
   * Name of the peering, which should conform to RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the peering, which should conform to RFC1035.
   * @param name name or {@code null} for none
   */
  public NetworksAddPeeringRequest setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the peer network. It can be either full URL or partial URL. The peer network may belong
   * to a different project. If the partial URL does not contain project, it is assumed that the
   * peer network is in the same project as the current network.
   * @return value or {@code null} for none
   */
  public java.lang.String getPeerNetwork() {
    return peerNetwork;
  }

  /**
   * URL of the peer network. It can be either full URL or partial URL. The peer network may belong
   * to a different project. If the partial URL does not contain project, it is assumed that the
   * peer network is in the same project as the current network.
   * @param peerNetwork peerNetwork or {@code null} for none
   */
  public NetworksAddPeeringRequest setPeerNetwork(java.lang.String peerNetwork) {
    this.peerNetwork = peerNetwork;
    return this;
  }

  @Override
  public NetworksAddPeeringRequest set(String fieldName, Object value) {
    return (NetworksAddPeeringRequest) super.set(fieldName, value);
  }

  @Override
  public NetworksAddPeeringRequest clone() {
    return (NetworksAddPeeringRequest) super.clone();
  }

}
