/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-23 at 23:59:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * InstanceGroupManagers.applyUpdatesToInstances
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionInstanceGroupManagersApplyUpdatesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The list of instances for which we want to apply changes on this managed instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> instances;

  /**
   * The maximal action that should be perfomed on the instances. By default REPLACE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maximalAction;

  /**
   * The minimal action that should be perfomed on the instances. By default NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minimalAction;

  /**
   * The list of instances for which we want to apply changes on this managed instance group.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInstances() {
    return instances;
  }

  /**
   * The list of instances for which we want to apply changes on this managed instance group.
   * @param instances instances or {@code null} for none
   */
  public RegionInstanceGroupManagersApplyUpdatesRequest setInstances(java.util.List<java.lang.String> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * The maximal action that should be perfomed on the instances. By default REPLACE.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaximalAction() {
    return maximalAction;
  }

  /**
   * The maximal action that should be perfomed on the instances. By default REPLACE.
   * @param maximalAction maximalAction or {@code null} for none
   */
  public RegionInstanceGroupManagersApplyUpdatesRequest setMaximalAction(java.lang.String maximalAction) {
    this.maximalAction = maximalAction;
    return this;
  }

  /**
   * The minimal action that should be perfomed on the instances. By default NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinimalAction() {
    return minimalAction;
  }

  /**
   * The minimal action that should be perfomed on the instances. By default NONE.
   * @param minimalAction minimalAction or {@code null} for none
   */
  public RegionInstanceGroupManagersApplyUpdatesRequest setMinimalAction(java.lang.String minimalAction) {
    this.minimalAction = minimalAction;
    return this;
  }

  @Override
  public RegionInstanceGroupManagersApplyUpdatesRequest set(String fieldName, Object value) {
    return (RegionInstanceGroupManagersApplyUpdatesRequest) super.set(fieldName, value);
  }

  @Override
  public RegionInstanceGroupManagersApplyUpdatesRequest clone() {
    return (RegionInstanceGroupManagersApplyUpdatesRequest) super.clone();
  }

}
