/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-30 at 19:31:32 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for Host.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Host extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] An optional textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Full or partial URL of the host type resource to use for this host, in the format:
   * zones/zone/hostTypes/host-type. This is provided by the client when the host is created. For
   * example, the following is a valid partial url to a predefined host type: zones/us-
   * central1-b/hostTypes/n1-host-64-416
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hostType;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * A list of resource URLs to the virtual machine instances in this host. They must live in zones
   * contained in the same region as this host.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> instances;

  /**
   * [Output Only] The type of the resource. Always compute#host for host.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the host.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelFingerprint;

  /**
   * Labels to apply to this host.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The name of the resource, provided by the client when initially creating the resource. The
   * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   * must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
   * which means the first character must be a lowercase letter, and all following characters must
   * be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] The status of the host. One of the following values: CREATING, READY, REPAIR, and
   * DELETING.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * [Output Only] The name of the zone where the host resides, such as us-central1-a.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Host setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] An optional textual description of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] An optional textual description of the resource.
   * @param description description or {@code null} for none
   */
  public Host setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Full or partial URL of the host type resource to use for this host, in the format:
   * zones/zone/hostTypes/host-type. This is provided by the client when the host is created. For
   * example, the following is a valid partial url to a predefined host type: zones/us-
   * central1-b/hostTypes/n1-host-64-416
   * @return value or {@code null} for none
   */
  public java.lang.String getHostType() {
    return hostType;
  }

  /**
   * Full or partial URL of the host type resource to use for this host, in the format:
   * zones/zone/hostTypes/host-type. This is provided by the client when the host is created. For
   * example, the following is a valid partial url to a predefined host type: zones/us-
   * central1-b/hostTypes/n1-host-64-416
   * @param hostType hostType or {@code null} for none
   */
  public Host setHostType(java.lang.String hostType) {
    this.hostType = hostType;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public Host setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * A list of resource URLs to the virtual machine instances in this host. They must live in zones
   * contained in the same region as this host.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInstances() {
    return instances;
  }

  /**
   * A list of resource URLs to the virtual machine instances in this host. They must live in zones
   * contained in the same region as this host.
   * @param instances instances or {@code null} for none
   */
  public Host setInstances(java.util.List<java.lang.String> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * [Output Only] The type of the resource. Always compute#host for host.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The type of the resource. Always compute#host for host.
   * @param kind kind or {@code null} for none
   */
  public Host setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the host.
   * @see #decodeLabelFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelFingerprint() {
    return labelFingerprint;
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the host.
   * @see #getLabelFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeLabelFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(labelFingerprint);
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the host.
   * @see #encodeLabelFingerprint()
   * @param labelFingerprint labelFingerprint or {@code null} for none
   */
  public Host setLabelFingerprint(java.lang.String labelFingerprint) {
    this.labelFingerprint = labelFingerprint;
    return this;
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the host.
   * @see #setLabelFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Host encodeLabelFingerprint(byte[] labelFingerprint) {
    this.labelFingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(labelFingerprint);
    return this;
  }

  /**
   * Labels to apply to this host.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels to apply to this host.
   * @param labels labels or {@code null} for none
   */
  public Host setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The name of the resource, provided by the client when initially creating the resource. The
   * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   * must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
   * which means the first character must be a lowercase letter, and all following characters must
   * be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the resource, provided by the client when initially creating the resource. The
   * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   * must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
   * which means the first character must be a lowercase letter, and all following characters must
   * be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public Host setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Host setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] The status of the host. One of the following values: CREATING, READY, REPAIR, and
   * DELETING.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of the host. One of the following values: CREATING, READY, REPAIR, and
   * DELETING.
   * @param status status or {@code null} for none
   */
  public Host setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * @param statusMessage statusMessage or {@code null} for none
   */
  public Host setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * [Output Only] The name of the zone where the host resides, such as us-central1-a.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] The name of the zone where the host resides, such as us-central1-a.
   * @param zone zone or {@code null} for none
   */
  public Host setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public Host set(String fieldName, Object value) {
    return (Host) super.set(fieldName, value);
  }

  @Override
  public Host clone() {
    return (Host) super.clone();
  }

}
