/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-30 at 19:30:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for WafExpressionSet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WafExpressionSet extends com.google.api.client.json.GenericJson {

  /**
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable"
   * is particularly useful if a policy likes to avail newer set of expressions without having to
   * change the policy. A given alias name can't be used for more than one entity set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> aliases;

  /**
   * List of available expressions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<WafExpressionSetExpression> expressions;

  /**
   * Google specified expression set ID. The format should be: - E.g. XSS-20170329
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable"
   * is particularly useful if a policy likes to avail newer set of expressions without having to
   * change the policy. A given alias name can't be used for more than one entity set.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAliases() {
    return aliases;
  }

  /**
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable"
   * is particularly useful if a policy likes to avail newer set of expressions without having to
   * change the policy. A given alias name can't be used for more than one entity set.
   * @param aliases aliases or {@code null} for none
   */
  public WafExpressionSet setAliases(java.util.List<java.lang.String> aliases) {
    this.aliases = aliases;
    return this;
  }

  /**
   * List of available expressions.
   * @return value or {@code null} for none
   */
  public java.util.List<WafExpressionSetExpression> getExpressions() {
    return expressions;
  }

  /**
   * List of available expressions.
   * @param expressions expressions or {@code null} for none
   */
  public WafExpressionSet setExpressions(java.util.List<WafExpressionSetExpression> expressions) {
    this.expressions = expressions;
    return this;
  }

  /**
   * Google specified expression set ID. The format should be: - E.g. XSS-20170329
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Google specified expression set ID. The format should be: - E.g. XSS-20170329
   * @param id id or {@code null} for none
   */
  public WafExpressionSet setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  @Override
  public WafExpressionSet set(String fieldName, Object value) {
    return (WafExpressionSet) super.set(fieldName, value);
  }

  @Override
  public WafExpressionSet clone() {
    return (WafExpressionSet) super.clone();
  }

}
