/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-15 at 22:22:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A Host Type resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HostType extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The CPU platform used by this host type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cpuPlatform;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] The deprecation status associated with this host type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * [Output Only] An optional textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The number of virtual CPUs that are available to the host type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer guestCpus;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] The type of the resource. Always compute#hostType for host types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] Local SSD available to the host type, defined in GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer localSsdGb;

  /**
   * [Output Only] The amount of physical memory available to the host type, defined in MB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer memoryMb;

  /**
   * [Output Only] Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] The name of the zone where the host type resides, such as us-central1-a.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] The CPU platform used by this host type.
   * @return value or {@code null} for none
   */
  public java.lang.String getCpuPlatform() {
    return cpuPlatform;
  }

  /**
   * [Output Only] The CPU platform used by this host type.
   * @param cpuPlatform cpuPlatform or {@code null} for none
   */
  public HostType setCpuPlatform(java.lang.String cpuPlatform) {
    this.cpuPlatform = cpuPlatform;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public HostType setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] The deprecation status associated with this host type.
   * @return value or {@code null} for none
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * [Output Only] The deprecation status associated with this host type.
   * @param deprecated deprecated or {@code null} for none
   */
  public HostType setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * [Output Only] An optional textual description of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] An optional textual description of the resource.
   * @param description description or {@code null} for none
   */
  public HostType setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The number of virtual CPUs that are available to the host type.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getGuestCpus() {
    return guestCpus;
  }

  /**
   * [Output Only] The number of virtual CPUs that are available to the host type.
   * @param guestCpus guestCpus or {@code null} for none
   */
  public HostType setGuestCpus(java.lang.Integer guestCpus) {
    this.guestCpus = guestCpus;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public HostType setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] The type of the resource. Always compute#hostType for host types.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The type of the resource. Always compute#hostType for host types.
   * @param kind kind or {@code null} for none
   */
  public HostType setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] Local SSD available to the host type, defined in GB.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLocalSsdGb() {
    return localSsdGb;
  }

  /**
   * [Output Only] Local SSD available to the host type, defined in GB.
   * @param localSsdGb localSsdGb or {@code null} for none
   */
  public HostType setLocalSsdGb(java.lang.Integer localSsdGb) {
    this.localSsdGb = localSsdGb;
    return this;
  }

  /**
   * [Output Only] The amount of physical memory available to the host type, defined in MB.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMemoryMb() {
    return memoryMb;
  }

  /**
   * [Output Only] The amount of physical memory available to the host type, defined in MB.
   * @param memoryMb memoryMb or {@code null} for none
   */
  public HostType setMemoryMb(java.lang.Integer memoryMb) {
    this.memoryMb = memoryMb;
    return this;
  }

  /**
   * [Output Only] Name of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource.
   * @param name name or {@code null} for none
   */
  public HostType setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public HostType setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] The name of the zone where the host type resides, such as us-central1-a.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] The name of the zone where the host type resides, such as us-central1-a.
   * @param zone zone or {@code null} for none
   */
  public HostType setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public HostType set(String fieldName, Object value) {
    return (HostType) super.set(fieldName, value);
  }

  @Override
  public HostType clone() {
    return (HostType) super.clone();
  }

}
