/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-15 at 22:22:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Diagnostics information about interconnect, contains detailed and current technical information
 * about Google?s side of the connection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectDiagnostics extends com.google.api.client.json.GenericJson {

  /**
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently
   * seen by the Google router in the ARP cache for the Interconnect. This will be empty when the
   * Interconnect is not bundled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectDiagnosticsARPEntry> arpCaches;

  /**
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on
   * the Interconnect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectDiagnosticsLinkStatus> links;

  /**
   * The MAC address of the Interconnect's bundle interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String macAddress;

  /**
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently
   * seen by the Google router in the ARP cache for the Interconnect. This will be empty when the
   * Interconnect is not bundled.
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectDiagnosticsARPEntry> getArpCaches() {
    return arpCaches;
  }

  /**
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently
   * seen by the Google router in the ARP cache for the Interconnect. This will be empty when the
   * Interconnect is not bundled.
   * @param arpCaches arpCaches or {@code null} for none
   */
  public InterconnectDiagnostics setArpCaches(java.util.List<InterconnectDiagnosticsARPEntry> arpCaches) {
    this.arpCaches = arpCaches;
    return this;
  }

  /**
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on
   * the Interconnect.
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectDiagnosticsLinkStatus> getLinks() {
    return links;
  }

  /**
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on
   * the Interconnect.
   * @param links links or {@code null} for none
   */
  public InterconnectDiagnostics setLinks(java.util.List<InterconnectDiagnosticsLinkStatus> links) {
    this.links = links;
    return this;
  }

  /**
   * The MAC address of the Interconnect's bundle interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getMacAddress() {
    return macAddress;
  }

  /**
   * The MAC address of the Interconnect's bundle interface.
   * @param macAddress macAddress or {@code null} for none
   */
  public InterconnectDiagnostics setMacAddress(java.lang.String macAddress) {
    this.macAddress = macAddress;
    return this;
  }

  @Override
  public InterconnectDiagnostics set(String fieldName, Object value) {
    return (InterconnectDiagnostics) super.set(fieldName, value);
  }

  @Override
  public InterconnectDiagnostics clone() {
    return (InterconnectDiagnostics) super.clone();
  }

}
