/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-15 at 22:22:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InternalIpAddress.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InternalIpAddress extends com.google.api.client.json.GenericJson {

  /**
   * IP CIDR address or range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cidr;

  /**
   * The owner of the internal IP address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String owner;

  /**
   * The purpose of the internal IP address if applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purpose;

  /**
   * The region of the internal IP address if applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * The type of the internal IP address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * IP CIDR address or range.
   * @return value or {@code null} for none
   */
  public java.lang.String getCidr() {
    return cidr;
  }

  /**
   * IP CIDR address or range.
   * @param cidr cidr or {@code null} for none
   */
  public InternalIpAddress setCidr(java.lang.String cidr) {
    this.cidr = cidr;
    return this;
  }

  /**
   * The owner of the internal IP address.
   * @return value or {@code null} for none
   */
  public java.lang.String getOwner() {
    return owner;
  }

  /**
   * The owner of the internal IP address.
   * @param owner owner or {@code null} for none
   */
  public InternalIpAddress setOwner(java.lang.String owner) {
    this.owner = owner;
    return this;
  }

  /**
   * The purpose of the internal IP address if applicable.
   * @return value or {@code null} for none
   */
  public java.lang.String getPurpose() {
    return purpose;
  }

  /**
   * The purpose of the internal IP address if applicable.
   * @param purpose purpose or {@code null} for none
   */
  public InternalIpAddress setPurpose(java.lang.String purpose) {
    this.purpose = purpose;
    return this;
  }

  /**
   * The region of the internal IP address if applicable.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * The region of the internal IP address if applicable.
   * @param region region or {@code null} for none
   */
  public InternalIpAddress setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * The type of the internal IP address.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the internal IP address.
   * @param type type or {@code null} for none
   */
  public InternalIpAddress setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public InternalIpAddress set(String fieldName, Object value) {
    return (InternalIpAddress) super.set(fieldName, value);
  }

  @Override
  public InternalIpAddress clone() {
    return (InternalIpAddress) super.clone();
  }

}
