/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-15 at 22:22:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A backup schedule policy specifies when and how frequently snapshots are to be created for the
 * target disk. Also specifies how many and how long these automatically created snapshot should be
 * retained.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyBackupSchedulePolicy extends com.google.api.client.json.GenericJson {

  /**
   * Retention policy applied to snapshots created by this resource policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourcePolicyBackupSchedulePolicyRetentionPolicy retentionPolicy;

  /**
   * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to
   * perform on this VM and when. Schedule that is applied to disks covered by this policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourcePolicyBackupSchedulePolicySchedule schedule;

  /**
   * Properties with which snapshots are created such as lables, encryption keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourcePolicyBackupSchedulePolicySnapshotProperties snapshotProperties;

  /**
   * Retention policy applied to snapshots created by this resource policy.
   * @return value or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicyRetentionPolicy getRetentionPolicy() {
    return retentionPolicy;
  }

  /**
   * Retention policy applied to snapshots created by this resource policy.
   * @param retentionPolicy retentionPolicy or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicy setRetentionPolicy(ResourcePolicyBackupSchedulePolicyRetentionPolicy retentionPolicy) {
    this.retentionPolicy = retentionPolicy;
    return this;
  }

  /**
   * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to
   * perform on this VM and when. Schedule that is applied to disks covered by this policy.
   * @return value or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicySchedule getSchedule() {
    return schedule;
  }

  /**
   * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to
   * perform on this VM and when. Schedule that is applied to disks covered by this policy.
   * @param schedule schedule or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicy setSchedule(ResourcePolicyBackupSchedulePolicySchedule schedule) {
    this.schedule = schedule;
    return this;
  }

  /**
   * Properties with which snapshots are created such as lables, encryption keys.
   * @return value or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicySnapshotProperties getSnapshotProperties() {
    return snapshotProperties;
  }

  /**
   * Properties with which snapshots are created such as lables, encryption keys.
   * @param snapshotProperties snapshotProperties or {@code null} for none
   */
  public ResourcePolicyBackupSchedulePolicy setSnapshotProperties(ResourcePolicyBackupSchedulePolicySnapshotProperties snapshotProperties) {
    this.snapshotProperties = snapshotProperties;
    return this;
  }

  @Override
  public ResourcePolicyBackupSchedulePolicy set(String fieldName, Object value) {
    return (ResourcePolicyBackupSchedulePolicy) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyBackupSchedulePolicy clone() {
    return (ResourcePolicyBackupSchedulePolicy) super.clone();
  }

}
