/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-28 at 19:49:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BackendServiceIAPOAuth2ClientInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceIAPOAuth2ClientInfo extends com.google.api.client.json.GenericJson {

  /**
   * Application name to be used in OAuth consent screen.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String applicationName;

  /**
   * Name of the client to be generated. Optional - If not provided, the name will be autogenerated
   * by the backend.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientName;

  /**
   * Developer's information to be used in OAuth consent screen.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String developerEmailAddress;

  /**
   * Application name to be used in OAuth consent screen.
   * @return value or {@code null} for none
   */
  public java.lang.String getApplicationName() {
    return applicationName;
  }

  /**
   * Application name to be used in OAuth consent screen.
   * @param applicationName applicationName or {@code null} for none
   */
  public BackendServiceIAPOAuth2ClientInfo setApplicationName(java.lang.String applicationName) {
    this.applicationName = applicationName;
    return this;
  }

  /**
   * Name of the client to be generated. Optional - If not provided, the name will be autogenerated
   * by the backend.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientName() {
    return clientName;
  }

  /**
   * Name of the client to be generated. Optional - If not provided, the name will be autogenerated
   * by the backend.
   * @param clientName clientName or {@code null} for none
   */
  public BackendServiceIAPOAuth2ClientInfo setClientName(java.lang.String clientName) {
    this.clientName = clientName;
    return this;
  }

  /**
   * Developer's information to be used in OAuth consent screen.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeveloperEmailAddress() {
    return developerEmailAddress;
  }

  /**
   * Developer's information to be used in OAuth consent screen.
   * @param developerEmailAddress developerEmailAddress or {@code null} for none
   */
  public BackendServiceIAPOAuth2ClientInfo setDeveloperEmailAddress(java.lang.String developerEmailAddress) {
    this.developerEmailAddress = developerEmailAddress;
    return this;
  }

  @Override
  public BackendServiceIAPOAuth2ClientInfo set(String fieldName, Object value) {
    return (BackendServiceIAPOAuth2ClientInfo) super.set(fieldName, value);
  }

  @Override
  public BackendServiceIAPOAuth2ClientInfo clone() {
    return (BackendServiceIAPOAuth2ClientInfo) super.clone();
  }

}
