/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-28 at 19:49:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InterconnectDiagnosticsLinkLACPStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectDiagnosticsLinkLACPStatus extends com.google.api.client.json.GenericJson {

  /**
   * System ID of the port on Google?s side of the LACP exchange.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String googleSystemId;

  /**
   * System ID of the port on the neighbor?s side of the LACP exchange.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String neighborSystemId;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * System ID of the port on Google?s side of the LACP exchange.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoogleSystemId() {
    return googleSystemId;
  }

  /**
   * System ID of the port on Google?s side of the LACP exchange.
   * @param googleSystemId googleSystemId or {@code null} for none
   */
  public InterconnectDiagnosticsLinkLACPStatus setGoogleSystemId(java.lang.String googleSystemId) {
    this.googleSystemId = googleSystemId;
    return this;
  }

  /**
   * System ID of the port on the neighbor?s side of the LACP exchange.
   * @return value or {@code null} for none
   */
  public java.lang.String getNeighborSystemId() {
    return neighborSystemId;
  }

  /**
   * System ID of the port on the neighbor?s side of the LACP exchange.
   * @param neighborSystemId neighborSystemId or {@code null} for none
   */
  public InterconnectDiagnosticsLinkLACPStatus setNeighborSystemId(java.lang.String neighborSystemId) {
    this.neighborSystemId = neighborSystemId;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * @param state state or {@code null} for none
   */
  public InterconnectDiagnosticsLinkLACPStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public InterconnectDiagnosticsLinkLACPStatus set(String fieldName, Object value) {
    return (InterconnectDiagnosticsLinkLACPStatus) super.set(fieldName, value);
  }

  @Override
  public InterconnectDiagnosticsLinkLACPStatus clone() {
    return (InterconnectDiagnosticsLinkLACPStatus) super.clone();
  }

}
