/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-08-10 at 05:32:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] A bit indicating whether the managed instance group is in a stable state. A
   * stable state means that: none of the instances in the managed instance group is currently
   * undergoing any type of change (for example, creation, restart, or deletion); no future changes
   * are scheduled for instances in the managed instance group; and the managed instance group
   * itself is not being modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isStable;

  /**
   * [Output Only] A bit indicating whether the managed instance group is in a stable state. A
   * stable state means that: none of the instances in the managed instance group is currently
   * undergoing any type of change (for example, creation, restart, or deletion); no future changes
   * are scheduled for instances in the managed instance group; and the managed instance group
   * itself is not being modified.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsStable() {
    return isStable;
  }

  /**
   * [Output Only] A bit indicating whether the managed instance group is in a stable state. A
   * stable state means that: none of the instances in the managed instance group is currently
   * undergoing any type of change (for example, creation, restart, or deletion); no future changes
   * are scheduled for instances in the managed instance group; and the managed instance group
   * itself is not being modified.
   * @param isStable isStable or {@code null} for none
   */
  public InstanceGroupManagerStatus setIsStable(java.lang.Boolean isStable) {
    this.isStable = isStable;
    return this;
  }

  @Override
  public InstanceGroupManagerStatus set(String fieldName, Object value) {
    return (InstanceGroupManagerStatus) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerStatus clone() {
    return (InstanceGroupManagerStatus) super.clone();
  }

}
