/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-08-15 at 00:47:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * This allocation type allows to pre allocate specific instance configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AllocationSpecificSKUAllocation extends com.google.api.client.json.GenericJson {

  /**
   * Specifies number of resources that are allocated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long count;

  /**
   * [OutputOnly] Indicates how many resource are in use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long inUseCount;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllocationSpecificSKUAllocationAllocatedInstanceProperties instanceProperties;

  /**
   * Specifies number of resources that are allocated.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCount() {
    return count;
  }

  /**
   * Specifies number of resources that are allocated.
   * @param count count or {@code null} for none
   */
  public AllocationSpecificSKUAllocation setCount(java.lang.Long count) {
    this.count = count;
    return this;
  }

  /**
   * [OutputOnly] Indicates how many resource are in use.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInUseCount() {
    return inUseCount;
  }

  /**
   * [OutputOnly] Indicates how many resource are in use.
   * @param inUseCount inUseCount or {@code null} for none
   */
  public AllocationSpecificSKUAllocation setInUseCount(java.lang.Long inUseCount) {
    this.inUseCount = inUseCount;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties getInstanceProperties() {
    return instanceProperties;
  }

  /**
   * @param instanceProperties instanceProperties or {@code null} for none
   */
  public AllocationSpecificSKUAllocation setInstanceProperties(AllocationSpecificSKUAllocationAllocatedInstanceProperties instanceProperties) {
    this.instanceProperties = instanceProperties;
    return this;
  }

  @Override
  public AllocationSpecificSKUAllocation set(String fieldName, Object value) {
    return (AllocationSpecificSKUAllocation) super.set(fieldName, value);
  }

  @Override
  public AllocationSpecificSKUAllocation clone() {
    return (AllocationSpecificSKUAllocation) super.clone();
  }

}
