/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-08-14 at 21:22:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Properties of the SKU instances being reserved.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AllocationSpecificSKUAllocationAllocatedInstanceProperties extends com.google.api.client.json.GenericJson {

  /**
   * Specifies accelerator type and count.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AcceleratorConfig> guestAccelerators;

  static {
    // hack to force ProGuard to consider AcceleratorConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AcceleratorConfig.class);
  }

  /**
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesAllocatedDisk> localSsds;

  /**
   * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of
   * memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-
   * AMOUNT_OF_MEMORY pattern.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * Minimum cpu platform the allocation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minCpuPlatform;

  /**
   * Specifies accelerator type and count.
   * @return value or {@code null} for none
   */
  public java.util.List<AcceleratorConfig> getGuestAccelerators() {
    return guestAccelerators;
  }

  /**
   * Specifies accelerator type and count.
   * @param guestAccelerators guestAccelerators or {@code null} for none
   */
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties setGuestAccelerators(java.util.List<AcceleratorConfig> guestAccelerators) {
    this.guestAccelerators = guestAccelerators;
    return this;
  }

  /**
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * @return value or {@code null} for none
   */
  public java.util.List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesAllocatedDisk> getLocalSsds() {
    return localSsds;
  }

  /**
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * @param localSsds localSsds or {@code null} for none
   */
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties setLocalSsds(java.util.List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesAllocatedDisk> localSsds) {
    this.localSsds = localSsds;
    return this;
  }

  /**
   * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of
   * memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-
   * AMOUNT_OF_MEMORY pattern.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of
   * memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-
   * AMOUNT_OF_MEMORY pattern.
   * @param machineType machineType or {@code null} for none
   */
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * Minimum cpu platform the allocation.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinCpuPlatform() {
    return minCpuPlatform;
  }

  /**
   * Minimum cpu platform the allocation.
   * @param minCpuPlatform minCpuPlatform or {@code null} for none
   */
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties setMinCpuPlatform(java.lang.String minCpuPlatform) {
    this.minCpuPlatform = minCpuPlatform;
    return this;
  }

  @Override
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties set(String fieldName, Object value) {
    return (AllocationSpecificSKUAllocationAllocatedInstanceProperties) super.set(fieldName, value);
  }

  @Override
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties clone() {
    return (AllocationSpecificSKUAllocationAllocatedInstanceProperties) super.clone();
  }

}
