/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-08-14 at 21:22:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for AllocationsUpdateResourceShapeRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AllocationsUpdateResourceShapeRequest extends com.google.api.client.json.GenericJson {

  /**
   * Number of allocated resources which are to be updated with minimum = 1 and maximum = 100.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer count;

  /**
   * The name of destination allocation where the modified machines are added. If existing, its
   * machine spec must match the modified machine spec. If non existing, new allocation with this
   * name and modified machine spec is created automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationAllocation;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllocationSpecificSKUAllocationAllocatedInstanceProperties updatedResourceProperties;

  /**
   * Number of allocated resources which are to be updated with minimum = 1 and maximum = 100.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCount() {
    return count;
  }

  /**
   * Number of allocated resources which are to be updated with minimum = 1 and maximum = 100.
   * @param count count or {@code null} for none
   */
  public AllocationsUpdateResourceShapeRequest setCount(java.lang.Integer count) {
    this.count = count;
    return this;
  }

  /**
   * The name of destination allocation where the modified machines are added. If existing, its
   * machine spec must match the modified machine spec. If non existing, new allocation with this
   * name and modified machine spec is created automatically.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationAllocation() {
    return destinationAllocation;
  }

  /**
   * The name of destination allocation where the modified machines are added. If existing, its
   * machine spec must match the modified machine spec. If non existing, new allocation with this
   * name and modified machine spec is created automatically.
   * @param destinationAllocation destinationAllocation or {@code null} for none
   */
  public AllocationsUpdateResourceShapeRequest setDestinationAllocation(java.lang.String destinationAllocation) {
    this.destinationAllocation = destinationAllocation;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public AllocationSpecificSKUAllocationAllocatedInstanceProperties getUpdatedResourceProperties() {
    return updatedResourceProperties;
  }

  /**
   * @param updatedResourceProperties updatedResourceProperties or {@code null} for none
   */
  public AllocationsUpdateResourceShapeRequest setUpdatedResourceProperties(AllocationSpecificSKUAllocationAllocatedInstanceProperties updatedResourceProperties) {
    this.updatedResourceProperties = updatedResourceProperties;
    return this;
  }

  @Override
  public AllocationsUpdateResourceShapeRequest set(String fieldName, Object value) {
    return (AllocationsUpdateResourceShapeRequest) super.set(fieldName, value);
  }

  @Override
  public AllocationsUpdateResourceShapeRequest clone() {
    return (AllocationsUpdateResourceShapeRequest) super.clone();
  }

}
