/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-08-15 at 04:17:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Allocation resource
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Allocation extends com.google.api.client.json.GenericJson {

  /**
   * Full or partial url for commitment in which this allocation is to be created. This field is
   * ignored when allocations are created during committment creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commitment;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#allocations for allocations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the resource, provided by the client when initially creating the resource. The
   * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   * must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
   * which means the first character must be a lowercase letter, and all following characters must
   * be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllocationSpecificSKUAllocation specificAllocation;

  /**
   * Indicates whether the allocation can be consumed by VMs with ?any allocation? defined. If the
   * field is set, then only VMs that target the allocation by name using --allocation-affinity can
   * consume this allocation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean specificAllocationRequired;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Full or partial url for commitment in which this allocation is to be created. This field is
   * ignored when allocations are created during committment creation.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommitment() {
    return commitment;
  }

  /**
   * Full or partial url for commitment in which this allocation is to be created. This field is
   * ignored when allocations are created during committment creation.
   * @param commitment commitment or {@code null} for none
   */
  public Allocation setCommitment(java.lang.String commitment) {
    this.commitment = commitment;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Allocation setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * @param description description or {@code null} for none
   */
  public Allocation setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public Allocation setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#allocations for allocations.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#allocations for allocations.
   * @param kind kind or {@code null} for none
   */
  public Allocation setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the resource, provided by the client when initially creating the resource. The
   * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   * must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
   * which means the first character must be a lowercase letter, and all following characters must
   * be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the resource, provided by the client when initially creating the resource. The
   * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   * must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
   * which means the first character must be a lowercase letter, and all following characters must
   * be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public Allocation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Allocation setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public AllocationSpecificSKUAllocation getSpecificAllocation() {
    return specificAllocation;
  }

  /**
   * @param specificAllocation specificAllocation or {@code null} for none
   */
  public Allocation setSpecificAllocation(AllocationSpecificSKUAllocation specificAllocation) {
    this.specificAllocation = specificAllocation;
    return this;
  }

  /**
   * Indicates whether the allocation can be consumed by VMs with ?any allocation? defined. If the
   * field is set, then only VMs that target the allocation by name using --allocation-affinity can
   * consume this allocation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSpecificAllocationRequired() {
    return specificAllocationRequired;
  }

  /**
   * Indicates whether the allocation can be consumed by VMs with ?any allocation? defined. If the
   * field is set, then only VMs that target the allocation by name using --allocation-affinity can
   * consume this allocation.
   * @param specificAllocationRequired specificAllocationRequired or {@code null} for none
   */
  public Allocation setSpecificAllocationRequired(java.lang.Boolean specificAllocationRequired) {
    this.specificAllocationRequired = specificAllocationRequired;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * @param zone zone or {@code null} for none
   */
  public Allocation setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public Allocation set(String fieldName, Object value) {
    return (Allocation) super.set(fieldName, value);
  }

  @Override
  public Allocation clone() {
    return (Allocation) super.clone();
  }

}
