/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-01 at 04:21:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration of a App Engine backend.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceAppEngineBackend extends com.google.api.client.json.GenericJson {

  /**
   * Optional. App Engine app service name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appEngineService;

  /**
   * Required. Project ID of the project hosting the app. This is the project ID of this project.
   * Reference to another project is not allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetProject;

  /**
   * Optional. Version of App Engine app service. When empty, App Engine will do its normal traffic
   * split.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String version;

  /**
   * Optional. App Engine app service name.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppEngineService() {
    return appEngineService;
  }

  /**
   * Optional. App Engine app service name.
   * @param appEngineService appEngineService or {@code null} for none
   */
  public BackendServiceAppEngineBackend setAppEngineService(java.lang.String appEngineService) {
    this.appEngineService = appEngineService;
    return this;
  }

  /**
   * Required. Project ID of the project hosting the app. This is the project ID of this project.
   * Reference to another project is not allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetProject() {
    return targetProject;
  }

  /**
   * Required. Project ID of the project hosting the app. This is the project ID of this project.
   * Reference to another project is not allowed.
   * @param targetProject targetProject or {@code null} for none
   */
  public BackendServiceAppEngineBackend setTargetProject(java.lang.String targetProject) {
    this.targetProject = targetProject;
    return this;
  }

  /**
   * Optional. Version of App Engine app service. When empty, App Engine will do its normal traffic
   * split.
   * @return value or {@code null} for none
   */
  public java.lang.String getVersion() {
    return version;
  }

  /**
   * Optional. Version of App Engine app service. When empty, App Engine will do its normal traffic
   * split.
   * @param version version or {@code null} for none
   */
  public BackendServiceAppEngineBackend setVersion(java.lang.String version) {
    this.version = version;
    return this;
  }

  @Override
  public BackendServiceAppEngineBackend set(String fieldName, Object value) {
    return (BackendServiceAppEngineBackend) super.set(fieldName, value);
  }

  @Override
  public BackendServiceAppEngineBackend clone() {
    return (BackendServiceAppEngineBackend) super.clone();
  }

}
